/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.command;

import org.eclipse.actf.util.command.DefaultArgumentResolver;
import org.eclipse.actf.util.command.IArgumentResolver;

public class CLSwitch {
    private String _name;
    private String _prefix = "-";
    private String _description = "";
    private String _value;
    private Object _resolvedValue;
    private String _defaultValue = "";
    private Class _type = Object.class;
    private boolean _required = false;
    private int _expectedArgs = 1;
    private IArgumentResolver _resolver;

    public CLSwitch(String name, String desc, Class type) {
        this(name, desc, type, false);
    }

    public CLSwitch(String name, String desc, IArgumentResolver resolver) {
        this(name, null, null, false, resolver);
    }

    public CLSwitch(String name, String desc, Class type, boolean required) {
        this(name, desc, type, required, null);
    }

    public CLSwitch(String name, String desc, Class type, boolean required, IArgumentResolver resolver) {
        this.setName(name);
        this.setDescription(desc);
        this.setValueType(type);
        this.setRequired(required);
        this.setArgumentResolver(resolver);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Switch names may not be null");
        }
        if (!Character.isLetter(name.charAt(0))) {
            throw new IllegalArgumentException("Switch names must begin with a letter: " + name);
        }
        int c = 1;
        while (c < name.length()) {
            if (!Character.isLetter(name.charAt(c)) && !Character.isDigit(name.charAt(c))) {
                throw new IllegalArgumentException("Switch names must be alpha-numeric: " + name);
            }
            ++c;
        }
        this._name = name;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix == null ? "-" : prefix;
    }

    public String getFullSwitchName() {
        return String.valueOf(this._prefix) + this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description == null ? "" : description;
    }

    public int getExpectedNumberOfArgs() {
        return this._expectedArgs;
    }

    public void setExpectedNumberOfArgs(int args) {
        this._expectedArgs = args >= 0 ? args : 1;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public Class getValueType() {
        return this._type;
    }

    public void setValueType(Class type) {
        this._type = type;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public Object resolveValue(String arg) throws Exception {
        if (this._resolvedValue == null) {
            this.setValue(arg);
            this._resolvedValue = this._type.equals(Boolean.class) || this._type.equals(Boolean.TYPE) ? Boolean.valueOf(this._value != null && this._value.equals("__true__")) : this._resolver.resolve(this._value, this._type);
        }
        return this._resolvedValue;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(String value) {
        this._defaultValue = this._value = value;
    }

    public void setToDefaultValue() {
        this._value = this._defaultValue;
    }

    public Object getResolvedValue() {
        Object result = this._resolvedValue;
        if (this._resolvedValue == null) {
            try {
                result = this.resolveValue(this._value);
            }
            catch (Exception e) {
                System.err.println("Could not resolve " + this._value + " for switch named " + this._name);
                e.printStackTrace();
            }
        }
        return result;
    }

    public IArgumentResolver getArgumentResolver() {
        return this._resolver;
    }

    public void setArgumentResolver(IArgumentResolver resolver) {
        this._resolver = resolver == null ? new DefaultArgumentResolver() : resolver;
    }
}

