/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipImploder {
    protected int dirCount;
    protected int fileCount;
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");
    protected boolean verbose;
    protected String baseDir;
    protected Manifest manifest;
    protected boolean includeDirs;

    public int getDirCount() {
        return this.dirCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public ZipImploder() {
        this(false);
    }

    public ZipImploder(boolean verbose) {
        this.setVerbose(verbose);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean f) {
        this.verbose = f;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) throws IOException {
        if (baseDir != null) {
            baseDir = new File(baseDir).getCanonicalPath();
            baseDir = baseDir.replace('\\', '/');
        }
        this.baseDir = baseDir;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public boolean getIncludeDirs() {
        return this.includeDirs;
    }

    public void setIncludeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
    }

    public void process(String zipName, String jarName, String sourceDir) throws IOException {
        this.dirCount = 0;
        this.fileCount = 0;
        if (zipName != null) {
            this.processZip(zipName, sourceDir);
        }
        if (jarName != null) {
            this.processJar(jarName, sourceDir);
        }
    }

    public void processJar(String jarName, String sourceDir) throws IOException {
        this.processJar(jarName, sourceDir, null);
    }

    public void processJar(String jarName, String sourceDir, String comment) throws IOException {
        this.processJar(jarName, sourceDir, comment, -1, -1);
    }

    public void processJar(String jarName, String sourceDir, String comment, int method, int level) throws IOException {
        String dest = this.setup(jarName, sourceDir);
        Manifest man = this.getManifest();
        JarOutputStream jos = man != null ? new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(dest)), man) : new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
        this.configure(jos, comment, method, level);
        this.process(jos, new File(sourceDir));
    }

    public void processZip(String zipName, String sourceDir) throws IOException {
        this.processZip(zipName, sourceDir, null);
    }

    public void processZip(String zipName, String sourceDir, String comment) throws IOException {
        this.processZip(zipName, sourceDir, comment, -1, -1);
    }

    public void processZip(String zipName, String sourceDir, String comment, int method, int level) throws IOException {
        String dest = this.setup(zipName, sourceDir);
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
        this.configure(zos, comment, method, level);
        this.process(zos, new File(sourceDir));
    }

    protected void configure(ZipOutputStream zos, String comment, int method, int level) {
        if (comment != null) {
            zos.setComment(comment);
        }
        if (method >= 0) {
            zos.setMethod(method);
        }
        if (level >= 0) {
            zos.setLevel(level);
        }
    }

    protected String setup(String zipName, String sourceDir) throws IOException {
        File dir = new File(sourceDir);
        if (!dir.exists() && !dir.isDirectory()) {
            throw new IOException("source must exist and be a directory: " + dir);
        }
        String source = dir.getCanonicalPath();
        String dest = new File(zipName).getCanonicalPath();
        if (this.verbose) {
            this.logger.log(Level.FINE, "\n**** Imploding " + source + " to " + dest);
        }
        return dest;
    }

    protected void process(ZipOutputStream zos, File dir) throws IOException {
        try {
            this.processDir(zos, dir);
        }
        finally {
            zos.close();
        }
    }

    protected String removeDrive(String path) {
        return path.length() >= 2 && path.charAt(1) == ':' ? path.substring(2) : path;
    }

    protected String removeLead(String path) {
        if (this.baseDir != null && path.startsWith(this.baseDir) && (path = path.substring(this.baseDir.length())).length() >= 1 && (path.charAt(0) == '/' || path.charAt(0) == '\\')) {
            path = path.substring(1);
        }
        return path;
    }

    public void processDir(ZipOutputStream zos, File dir) throws IOException {
        String path = dir.getCanonicalPath();
        path = path.replace('\\', '/');
        if (this.includeDirs) {
            if (this.baseDir == null || path.length() > this.baseDir.length()) {
                String xpath = this.removeDrive(this.removeLead(path));
                if (xpath.length() > 0) {
                    xpath = String.valueOf(xpath) + '/';
                    if (this.verbose) {
                        this.logger.log(Level.FINE, "\nProcessing directory " + path + " to " + xpath);
                    }
                    ZipEntry ze = new ZipEntry(xpath);
                    zos.putNextEntry(ze);
                } else if (this.verbose) {
                    this.logger.log(Level.FINE, "\nSkipping empty path");
                }
            } else if (this.verbose) {
                this.logger.log(Level.FINE, "\nDropping " + path);
            }
        } else if (this.verbose) {
            this.logger.log(Level.FINE, "\nSkipping " + path);
        }
        ++this.dirCount;
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            File f = new File(dir, file);
            if (f.isDirectory()) {
                this.processDir(zos, f);
            } else {
                this.processFile(zos, f);
            }
            ++i;
        }
    }

    public void processFile(ZipOutputStream zos, File f) throws IOException {
        String path = f.getCanonicalPath();
        path = path.replace('\\', '/');
        String xpath = this.removeDrive(this.removeLead(path));
        if (this.verbose) {
            this.logger.log(Level.FINE, "Processing file " + path + " to " + xpath);
        }
        ZipEntry ze = new ZipEntry(xpath);
        ze.setTime(f.lastModified());
        ze.setSize(f.length());
        zos.putNextEntry(ze);
        ++this.fileCount;
        try {
            this.copyFileEntry(zos, f);
        }
        finally {
            zos.closeEntry();
        }
    }

    protected void copyFileEntry(ZipOutputStream zos, File f) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
        try {
            this.copyFileEntry(zos, dis);
        }
        catch (Throwable throwable) {
            try {
                dis.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            dis.close();
        }
        catch (IOException iOException) {}
    }

    protected void copyFileEntry(ZipOutputStream zos, DataInputStream dis) throws IOException {
        byte[] bytes = this.readAllBytes(dis);
        this.logger.log(Level.FINE, "Writing " + bytes.length + " bytes...");
        zos.write(bytes, 0, bytes.length);
    }

    protected byte[] readAllBytes(DataInputStream is) throws IOException {
        byte[] bytes = new byte[]{};
        int len = is.available();
        while (len > 0) {
            byte[] xbytes = new byte[len];
            int count = is.read(xbytes);
            this.logger.log(Level.FINE, "readAllBytes: " + len + " vs. " + count);
            if (count > 0) {
                byte[] nbytes = new byte[bytes.length + count];
                System.arraycopy(bytes, 0, nbytes, 0, bytes.length);
                System.arraycopy(xbytes, 0, nbytes, bytes.length, count);
                bytes = nbytes;
            }
            len = is.available();
        }
        return bytes;
    }

    protected void print(String s) {
        System.out.print(s);
    }

    public static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + ZipImploder.class.getName());
        System.out.println("       (-jar <jarName> {-manifest <manfile>} | -zip <zipName>)");
        System.out.println("       -dir <sourceDir> {-lead <leadDir>} {-doDirs} {-verbose}");
        System.out.println("Where:");
        System.out.println("  <jarName>     path to target jar");
        System.out.println("  <zipName>     path to target zip");
        System.out.println("  <manfile>     path to manifest file");
        System.out.println("  <sourceDir>   path to source directory; must exist");
        System.out.println("  <leadDir>     partial lead path to remove from stored entries; default: <sourceDir>");
        System.out.println("  <noDirs>      skip output of directory entries");
        System.out.println("  <verbose>     output progress information");
        System.out.println("Note: switch case or order is not important");
    }

    protected static void reportError(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ZipImploder.printHelp();
            System.exit(0);
        }
        String zipName = null;
        String jarName = null;
        String manName = null;
        String sourceDir = null;
        String leadDir = null;
        boolean jarActive = false;
        boolean manActive = false;
        boolean zipActive = false;
        boolean sourceDirActive = false;
        boolean leadDirActive = false;
        boolean verbose = false;
        boolean noDirs = false;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if ((arg = arg.substring(1)).equalsIgnoreCase("jar")) {
                    jarActive = true;
                    manActive = false;
                    zipActive = false;
                    sourceDirActive = false;
                    leadDirActive = false;
                } else if (arg.equalsIgnoreCase("manifest")) {
                    jarActive = false;
                    manActive = true;
                    zipActive = false;
                    sourceDirActive = false;
                    leadDirActive = false;
                } else if (arg.equalsIgnoreCase("zip")) {
                    zipActive = true;
                    manActive = false;
                    jarActive = false;
                    sourceDirActive = false;
                    leadDirActive = false;
                } else if (arg.equalsIgnoreCase("dir")) {
                    jarActive = false;
                    manActive = false;
                    zipActive = false;
                    sourceDirActive = true;
                    leadDirActive = false;
                } else if (arg.equalsIgnoreCase("lead")) {
                    jarActive = false;
                    manActive = false;
                    zipActive = false;
                    sourceDirActive = false;
                    leadDirActive = true;
                } else if (arg.equalsIgnoreCase("noDirs")) {
                    noDirs = true;
                    jarActive = false;
                    manActive = false;
                    zipActive = false;
                    sourceDirActive = false;
                    leadDirActive = false;
                } else if (arg.equalsIgnoreCase("verbose")) {
                    verbose = true;
                    jarActive = false;
                    manActive = false;
                    zipActive = false;
                    sourceDirActive = false;
                    leadDirActive = false;
                } else {
                    ZipImploder.reportError("Invalid switch - " + arg);
                }
            } else if (jarActive) {
                if (jarName != null) {
                    ZipImploder.reportError("Duplicate value - " + arg);
                }
                jarName = arg;
            } else if (manActive) {
                if (manName != null) {
                    ZipImploder.reportError("Duplicate value - " + arg);
                }
                manName = arg;
            } else if (zipActive) {
                if (zipName != null) {
                    ZipImploder.reportError("Duplicate value - " + arg);
                }
                zipName = arg;
            } else if (sourceDirActive) {
                if (sourceDir != null) {
                    ZipImploder.reportError("Duplicate value - " + arg);
                }
                sourceDir = arg;
            } else if (leadDirActive) {
                if (leadDir != null) {
                    ZipImploder.reportError("Duplicate value - " + arg);
                }
                leadDir = arg;
            } else {
                ZipImploder.reportError("Too many parameters - " + arg);
            }
            ++i;
        }
        if (sourceDir == null || zipName == null && jarName == null) {
            ZipImploder.reportError("Missing parameters");
        }
        if (manName != null && zipName != null) {
            ZipImploder.reportError("Manifests not supported on ZIP files");
        }
        if (leadDir == null) {
            leadDir = String.valueOf(new File(sourceDir).getAbsolutePath().replace('\\', '/')) + '/';
        }
        if (verbose) {
            System.out.println("Effective command: " + ZipImploder.class.getName() + (jarName != null ? " -jar " + jarName + (manName != null ? " -manifest " + manName : "") : "") + (zipName != null ? " -zip " + zipName : "") + " -dir " + sourceDir + " -lead " + leadDir + (noDirs ? " -noDirs" : "") + (verbose ? " -verbose" : ""));
        }
        try {
            ZipImploder zi = new ZipImploder(verbose);
            if (leadDir != null) {
                zi.setBaseDir(leadDir);
            }
            if (manName != null) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(manName));
                try {
                    zi.setManifest(new Manifest(bis));
                }
                finally {
                    bis.close();
                }
            }
            zi.setIncludeDirs(!noDirs);
            zi.process(zipName, jarName, sourceDir);
            if (verbose) {
                System.out.println("\nDone Directories=" + zi.getDirCount() + " Files=" + zi.getFileCount());
            }
        }
        catch (IOException ioe) {
            System.err.println("Exception - " + ioe.getMessage());
            System.exit(2);
        }
    }
}

