/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.IHTTPProxy;
import org.eclipse.actf.util.httpproxy.ProxyConfig;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServerFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoderFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverriderFactory;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.IObjectPool;
import org.eclipse.actf.util.internal.httpproxy.IWorkpileController;
import org.eclipse.actf.util.internal.httpproxy.ObjectPoolImpl;
import org.eclipse.actf.util.internal.httpproxy.WorkpileControllerImpl;
import org.eclipse.actf.util.internal.httpproxy.core.ClientConnectionListener;
import org.eclipse.actf.util.internal.httpproxy.proxy.ClientStateManager;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPProxyConnection;

public class HTTPProxy
implements ClientConnectionListener,
IHTTPProxy {
    private static final Logger LOGGER = Logger.getLogger(HTTPProxy.class);
    private final IWorkpileController wpc;
    private final ServerSocket fServerSock;
    private final long fKeepAlive;
    private final int fQueueSize;
    private final IObjectPool connectionPool;
    private final ISecretManager secretManager;
    private final IHTTPSessionOverriderFactory sessionOverriderFactory;
    private final IHTTPProxyTranscoderFactory proxyTranscoderFactory;
    private final IHTTPLocalServerFactory localServerFactory;
    private ExternalProxyConfig externalProxyConfig;
    private boolean exit = false;
    private ProxyThread proxyThread;
    private static final String USAGE_PARAMS = " <localport>";

    public ISecretManager getSecretManager() {
        return this.secretManager;
    }

    public int getListenPort() {
        return this.fServerSock.getLocalPort();
    }

    public ExternalProxyConfig getExternalProxyConfig() {
        return this.externalProxyConfig;
    }

    public IHTTPSessionOverriderFactory getSessionOverriderFactory() {
        return this.sessionOverriderFactory;
    }

    public IHTTPProxyTranscoderFactory getProxyTranscoderFactory() {
        return this.proxyTranscoderFactory;
    }

    public IHTTPLocalServerFactory getLocalServerFactory() {
        return this.localServerFactory;
    }

    public HTTPProxy(ProxyConfig config, ExternalProxyConfig externalProxyConfig) throws IOException {
        Logger.setConfigPropertyName("WaXcoding.conf.logging");
        this.externalProxyConfig = externalProxyConfig;
        this.wpc = new WorkpileControllerImpl("WaXcoding");
        this.fServerSock = new ServerSocket();
        InetSocketAddress sa = new InetSocketAddress("localhost", config.getPort());
        this.fServerSock.bind(sa);
        this.fKeepAlive = config.getKeepAliveInterval();
        this.fQueueSize = config.getMaxQueueSize();
        this.connectionPool = new ObjectPoolImpl("WaXcoding-clientconnections");
        int i = 0;
        while (i < config.getMaxConnection()) {
            HTTPProxyConnection obj = new HTTPProxyConnection(this, this.fQueueSize, config.getTimeout());
            this.connectionPool.add(obj);
            ++i;
        }
        this.secretManager = config.getSecretManager();
        this.sessionOverriderFactory = config.getSessionOverriderFactory();
        this.proxyTranscoderFactory = config.getProxyTranscoderFactory();
        this.localServerFactory = config.getLocalServerFactory();
    }

    public String getSecret(String id, boolean remove) {
        if (this.secretManager == null) {
            return null;
        }
        return this.secretManager.getSecret(id, remove);
    }

    public synchronized int getCurrentServerGroupIndex() {
        return 0;
    }

    public void connectionClosed(IClientConnection obj) {
        this.connectionPool.add(obj);
    }

    private void startProxy() {
        LOGGER.info("Started WaXcoding, Listening port " + this.fServerSock.getLocalPort());
        while (true) {
            Socket sock = null;
            try {
                HTTPProxyConnection connection = (HTTPProxyConnection)this.connectionPool.take(0);
                sock = this.fServerSock.accept();
                sock.setSoTimeout(1);
                if (this.exit) break;
                connection.init(ClientStateManager.getClientStateManager(this), sock, this.fKeepAlive, this.getCurrentServerGroupIndex());
                this.wpc.input(connection);
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (!this.exit) continue;
                LOGGER.info("Stopping WaXcoding...");
            }
            catch (SocketException socketException) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(this.wpc.toString());
                continue;
            }
            break;
        }
    }

    private void cleanup() {
        LOGGER.info("...done");
    }

    public void startThread() {
        if (this.proxyThread != null) {
            return;
        }
        this.proxyThread = new ProxyThread();
        this.proxyThread.start();
    }

    public void stopThread() {
        this.proxyThread.exit();
        this.proxyThread = null;
    }

    private static void PRINT_USAGE(String msg) {
        if (msg != null && msg.length() > 0) {
            System.err.println(msg);
        }
        System.err.println("Usage: java " + HTTPProxy.class.getName() + USAGE_PARAMS);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            HTTPProxy.PRINT_USAGE(null);
            System.exit(1);
        }
        int argsOffset = 0;
        int localport = Integer.parseInt(args[argsOffset++]);
        ProxyConfig config = new ProxyConfig();
        ExternalProxyConfig externalProxyConfig = new ExternalProxyConfig();
        try {
            Logger.configure();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            HTTPProxy proxy = new HTTPProxy(config, externalProxyConfig);
            proxy.startProxy();
        }
        catch (IOException iOException) {
            System.err.println("Port is in use: " + localport);
            System.exit(1);
        }
    }

    private class ProxyThread
    extends Thread {
        private boolean threadExit;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void exit() {
            HTTPProxy.this.exit = true;
            ProxyThread proxyThread = this;
            synchronized (proxyThread) {
                while (true) {
                    if (this.threadExit) {
                        return;
                    }
                    this.interrupt();
                    try {
                        HTTPProxy.this.fServerSock.close();
                        this.wait(1000L);
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HTTPProxy.this.startProxy();
            HTTPProxy.this.cleanup();
            ProxyThread proxyThread = this;
            synchronized (proxyThread) {
                this.threadExit = true;
                this.notifyAll();
            }
        }

        ProxyThread() {
            super("ProxyThread");
            this.threadExit = false;
        }
    }
}

