/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.InputStream;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryInputStream;

public class MessageBody
implements IMessageBody {
    private final InputStream fMessageBody;
    private final SocketTimeoutRetryInputStream fMessageBodySocketTimeoutRetry;
    private int fContentLength;
    private boolean isChunkedEncoding;

    public MessageBody(InputStream msgBody, int contentLength) {
        this.fMessageBody = msgBody;
        this.fMessageBodySocketTimeoutRetry = new SocketTimeoutRetryInputStream(msgBody);
        this.fContentLength = contentLength;
        this.isChunkedEncoding = false;
    }

    public MessageBody(InputStream msgBody) {
        this.fMessageBody = msgBody;
        this.fMessageBodySocketTimeoutRetry = new SocketTimeoutRetryInputStream(msgBody);
        this.fContentLength = -1;
        this.isChunkedEncoding = true;
    }

    public int getContentLength() {
        return this.fContentLength;
    }

    public boolean isChunkedEncoding() {
        return this.isChunkedEncoding;
    }

    public InputStream getMessageBodyTimeoutInputStream() {
        return this.fMessageBody;
    }

    public InputStream getMessageBodyInputStream() {
        return this.fMessageBodySocketTimeoutRetry;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MessageBody[");
        if (this.isChunkedEncoding) {
            sb.append("chunked");
        } else {
            sb.append("ContentLength=").append(this.fContentLength);
        }
        sb.append(']');
        return sb.toString();
    }
}

