/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.voice.preferences;

import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.ai.voice.internal.Messages;
import org.eclipse.actf.ai.voice.internal.Voice;
import org.eclipse.actf.ai.voice.internal.VoicePlugin;
import org.eclipse.actf.ai.voice.preferences.util.GroupFieldEditorVoicePreferencePage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class VoicePreferencePage
extends GroupFieldEditorVoicePreferencePage
implements IWorkbenchPreferencePage {
    private static final String SAMPLE_TEXT = "Hello. This is test.";
    private static IVoice voice = VoiceUtil.getVoice();

    public VoicePreferencePage() {
        this.setPreferenceStore(VoicePlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.voice_description);
    }

    public void createFieldEditors() {
        String[][] labelAndIds = TTSRegistry.getLabelAndIds();
        RadioGroupFieldEditor rgfe = new RadioGroupFieldEditor("activeEngine", Messages.voice_engine, 1, labelAndIds, this.getFieldEditorParent());
        this.addField((FieldEditor)rgfe);
        Composite c = rgfe.getRadioBoxControl(this.getFieldEditorParent());
        int i = 0;
        while (i < labelAndIds.length) {
            if (labelAndIds[i][1].length() == 0) {
                c.getChildren()[i].setEnabled(false);
            }
            ++i;
        }
        final ScaleFieldEditor speedEditor = new ScaleFieldEditor("defaultSpeed", Messages.voice_speed, this.getFieldEditorParent(), 0, 100, 5, 25);
        this.addField((FieldEditor)speedEditor);
        Composite comp = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(128);
        gd.horizontalSpan = speedEditor.getNumberOfControls();
        comp.setLayoutData((Object)gd);
        Button testButton = new Button(comp, 0);
        testButton.setText(Messages.voice_test);
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                voice.setSpeed(speedEditor.getScaleControl().getSelection());
                voice.speak(VoicePreferencePage.SAMPLE_TEXT, false);
            }
        });
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
        ((Voice)voice).setSpeed();
    }
}

