/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.eclipse.actf.model.internal.dom.html.impl.SHSelectElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLOptionElement;

public class SHOptionElement
extends SHElement
implements HTMLOptionElement {
    private static final long serialVersionUID = -3164490828413522255L;
    private boolean defaultSelected;

    protected SHOptionElement(String tagName, SHDocument doc) {
        super(tagName, doc);
    }

    public HTMLFormElement getForm() {
        Node ret = this.getParentNode();
        while (ret != null) {
            if (ret instanceof HTMLFormElement) {
                return (HTMLFormElement)ret;
            }
            ret = ret.getParentNode();
        }
        return null;
    }

    public boolean getDefaultSelected() {
        return this.defaultSelected;
    }

    public void setDefaultSelected(boolean defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    public String getText() {
        Node child = this.getFirstChild();
        return child == null ? null : child.getNodeValue();
    }

    public int getIndex() {
        Node anc = this.getParentNode();
        while (anc != null) {
            if (anc instanceof SHSelectElement) {
                SHSelectElement sel = (SHSelectElement)anc;
                HTMLCollection options = sel.getOptions();
                int i = 0;
                while (i < options.getLength()) {
                    if (options.item(i) == this) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
            anc = anc.getParentNode();
        }
        return -1;
    }

    public void setIndex(int index) {
        Node anc = this.getParentNode();
        while (anc != null) {
            if (anc instanceof SHSelectElement) {
                SHSelectElement sel = (SHSelectElement)anc;
                HTMLCollection options = sel.getOptions();
                if (index < 0 || options.getLength() <= index) {
                    return;
                }
                SHOptionElement nextSibling = (SHOptionElement)options.item(index);
                Node newParent = nextSibling.getParentNode();
                this.getParentNode().removeChild(this);
                newParent.insertBefore(this, nextSibling);
            }
            anc = anc.getParentNode();
        }
    }

    public boolean getSelected() {
        String val = this.getAttribute("selected");
        return val != null && val.length() != 0;
    }

    public void setSelected(boolean selected) {
        this.setAttribute("selected", selected ? "selected" : null);
    }

    public boolean getDisabled() {
        String val = this.getAttribute("disabled");
        return val != null && val.length() != 0;
    }

    public void setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled ? "disabled" : null);
    }

    public String getLabel() {
        return this.getAttribute("label");
    }

    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public void setValue(String value) {
        this.setAttribute("value", value);
    }
}

