/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class SHTableRowElement
extends SHElement
implements HTMLTableRowElement {
    private static final long serialVersionUID = 8399058496811877036L;

    protected SHTableRowElement(String name, SHDocument doc) {
        super(name, doc);
    }

    public int getRowIndex() {
        Node table = this.getParentNode().getParentNode();
        if (table instanceof HTMLTableElement) {
            HTMLCollection rows = ((HTMLTableElement)table).getRows();
            int ret = 0;
            while (ret < rows.getLength()) {
                if (rows.item(ret) == this) {
                    return ret;
                }
                ++ret;
            }
            throw new RuntimeException("Internal DOM Implementation Error.");
        }
        int ret = 0;
        Node prev = this.getPreviousSibling();
        while (prev != null) {
            if (prev instanceof HTMLTableRowElement) {
                ++ret;
            }
            prev = prev.getPreviousSibling();
        }
        return ret;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        Node table = this.getParentNode().getParentNode();
        if (table instanceof HTMLTableElement) {
            this.getParentNode().removeChild(this);
            HTMLCollection rows = ((HTMLTableElement)table).getRows();
            if (rows.getLength() < rowIndex) {
                return;
            }
            Node after = rows.item(rowIndex);
            Node newParent = after.getParentNode();
            newParent.insertBefore(this, after);
        } else {
            Node after = this.getParentNode().getFirstChild();
            int count = 0;
            while (count < rowIndex && after != null) {
                if (after instanceof HTMLTableRowElement) {
                    ++count;
                }
                after = after.getNextSibling();
            }
            if (after == null) {
                return;
            }
            this.getParentNode().removeChild(this);
            after.getParentNode().insertBefore(this, after);
        }
    }

    public int getSectionRowIndex() {
        int ret = 0;
        Node prev = this.getPreviousSibling();
        while (prev != null) {
            if (prev instanceof HTMLTableRowElement) {
                ++ret;
            }
            prev = prev.getPreviousSibling();
        }
        return ret;
    }

    public void setSectionRowIndex(int sectionRowIndex) {
        if (sectionRowIndex < 0) {
            return;
        }
        Node after = this.getParentNode().getFirstChild();
        int count = 0;
        while (count < sectionRowIndex && after != null) {
            if (after instanceof HTMLTableRowElement) {
                ++count;
            }
            after = after.getNextSibling();
        }
        if (after == null) {
            return;
        }
        this.getParentNode().removeChild(this);
        after.getParentNode().insertBefore(this, after);
    }

    public HTMLCollection getCells() {
        int len = 0;
        Node[] cells = new HTMLTableCellElement[8];
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableCellElement) {
                if (cells.length == len) {
                    HTMLTableCellElement[] buf = new HTMLTableCellElement[len * 2];
                    System.arraycopy(cells, 0, buf, 0, len);
                    cells = buf;
                }
                cells[len++] = (HTMLTableCellElement)child;
            }
            child = child.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(cells, len);
    }

    public void setCells(HTMLCollection cells) {
        while (this.hasChildNodes()) {
            this.removeChild(this.getFirstChild());
        }
        int i = 0;
        while (i < cells.getLength()) {
            this.insertBefore(cells.item(i), null);
            ++i;
        }
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public String getCh() {
        return this.getAttribute("char");
    }

    public void setCh(String ch) {
        this.setAttribute("char", ch);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    public String getVAlign() {
        return this.getAttribute("valing");
    }

    public void setVAlign(String vAlign) {
        this.setAttribute("valing", vAlign);
    }

    public HTMLElement insertCell(int index) {
        if (index < 0) {
            return null;
        }
        Node after = this.getFirstChild();
        int i = 0;
        while (i < index && after != null) {
            after = after.getNextSibling();
            ++i;
        }
        if (after == null && i != 0) {
            return null;
        }
        HTMLElement ret = (HTMLElement)this.getOwnerDocument().createElement("TD");
        this.insertBefore(ret, after);
        return ret;
    }

    public void deleteCell(int index) {
        if (index < 0) {
            return;
        }
        Node target = this.getFirstChild();
        int i = 0;
        while (i < index) {
            if (target == null) {
                return;
            }
            ++i;
        }
        this.removeChild(target);
    }
}

