/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDParseException;

public class AttributeDefinition {
    static final int CDATA = 1;
    static final int ID = 2;
    static final int IDREF = 3;
    static final int IDREFS = 4;
    static final int NUMBER = 5;
    static final int NAME = 6;
    static final int NAME_TOKEN_GROUP = 7;
    static final int NMTOKEN = 8;
    static final int NAMES = 9;
    static final int FIXED = 1;
    static final int REQUIRED = 2;
    static final int IMPLIED = 3;
    private int declaredType = 0;
    private int defaultType = 0;
    private String name;
    String defaultValue;
    private Vector<String> nameTokens;
    private String[] declaredTypeStrs;
    private static String[] declaredValueTable;
    private static String[] defaultValueTable;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "CDATA";
        stringArray[2] = "ID";
        stringArray[3] = "IDREF";
        stringArray[4] = "IDREFS";
        stringArray[5] = "NUMBER";
        stringArray[6] = "NAME";
        stringArray[8] = "NMTOKEN";
        declaredValueTable = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[1] = "#FIXED";
        stringArray2[2] = "#REQUIRED";
        stringArray2[3] = "#IMPLIED";
        defaultValueTable = stringArray2;
    }

    AttributeDefinition(String name) {
        String[] stringArray = new String[10];
        stringArray[1] = "CDATA";
        stringArray[2] = "ID";
        stringArray[3] = "IDREF";
        stringArray[4] = "IDREFS";
        stringArray[5] = "NUMBER";
        stringArray[6] = "NAME";
        stringArray[7] = "NAME_TOKEN_GROUP";
        stringArray[8] = "NMTOKEN";
        stringArray[9] = "NAMES";
        this.declaredTypeStrs = stringArray;
        this.name = name;
    }

    void addNameToken(String token) throws ParseException {
        if (this.declaredType != 7) {
            throw new DTDParseException();
        }
        if (this.nameTokens == null) {
            this.nameTokens = new Vector();
        }
        this.nameTokens.addElement(token);
    }

    int getDeclaredType() {
        return this.declaredType;
    }

    String getDeclaredTypeStr() {
        return this.declaredTypeStrs[this.declaredType];
    }

    int getDefaultType() {
        return this.defaultType;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    String getName() {
        return this.name;
    }

    boolean nameTokenGroupContain(String token) {
        return this.nameTokens.contains(token);
    }

    void setDeclaredType(int type) {
        this.declaredType = type;
    }

    void setDefaultType(int type) {
        this.defaultType = type;
    }

    void setDefaultValue(String str) {
        this.defaultValue = str;
    }

    void setName(String arg) {
        this.name = arg;
    }

    public String toString() {
        String ret = String.valueOf(this.name) + '\t';
        if (this.declaredType == 7) {
            Enumeration<String> e = this.nameTokens.elements();
            while (e.hasMoreElements()) {
                ret = String.valueOf(ret) + ' ' + e.nextElement();
            }
        } else {
            ret = String.valueOf(ret) + declaredValueTable[this.declaredType];
        }
        ret = String.valueOf(ret) + '\t';
        if (defaultValueTable[this.defaultType] != null) {
            ret = String.valueOf(ret) + defaultValueTable[this.defaultType] + ' ';
        }
        if (this.defaultValue != null) {
            ret = String.valueOf(ret) + this.defaultValue;
        }
        return ret;
    }
}

