/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementDefinition
implements IModelGroup {
    private boolean start;
    private boolean end;
    private String name;
    private IModelGroup contentModel;
    private ElementDefinition[] inclusions;
    private ElementDefinition[] exclusions;
    private AttributeDefinition[] attributeDefs = new AttributeDefinition[32];
    private int[] attributeDefHashes = new int[32];
    private int attrNum = 0;
    private int refercount = 0;
    private boolean infinite = false;
    int number;
    private boolean[] inclusionVector;
    private boolean[] exclusionVector;
    private boolean[] hash = null;

    protected ElementDefinition(String name) {
        this.name = name;
    }

    protected ElementDefinition(String name, IModelGroup contentModel) {
        this.name = name;
        this.contentModel = contentModel;
    }

    final void addAttributeDefinition(AttributeDefinition def) {
        if (def != null) {
            if (this.attrNum == this.attributeDefs.length) {
                AttributeDefinition[] newDefs = new AttributeDefinition[this.attrNum * 2];
                int[] newHashes = new int[this.attrNum * 2];
                int i = 0;
                while (i < this.attrNum) {
                    newDefs[i] = this.attributeDefs[i];
                    newHashes[i] = this.attributeDefHashes[i];
                    ++i;
                }
                this.attributeDefs = newDefs;
                this.attributeDefHashes = newHashes;
            }
            this.attributeDefs[this.attrNum] = def;
            this.attributeDefHashes[this.attrNum++] = this.hashCode(def.getName().toCharArray());
        }
    }

    public final boolean endTagOmittable() {
        return this.end;
    }

    public boolean match(ISGMLParser parser, Node parent, Node child) {
        if (child instanceof Element && child.getNodeName().equalsIgnoreCase(this.name)) {
            parent.appendChild(child);
            return true;
        }
        if (this.start) {
            boolean ret;
            Element tmp = parser.getDocument().createElement(parser.changeDefaultTagCase(this.name));
            if (child instanceof Element) {
                Element ec = (Element)child;
                if (this.exclusion(ec)) {
                    return false;
                }
                if (this.inclusion(ec)) {
                    tmp.appendChild(child);
                    parent.appendChild(tmp);
                    parser.addAutoGenerated(tmp);
                    return true;
                }
            }
            if (ret = this.contentModel.match(parser, tmp, child)) {
                parent.appendChild(tmp);
                parser.addAutoGenerated(tmp);
                return true;
            }
        }
        return false;
    }

    final IModelGroup getContentModel() {
        return this.contentModel;
    }

    public boolean contentMatch(ISGMLParser parser, Node parent, Node child) {
        return this.contentModel.match(parser, parent, child);
    }

    public final String getDefaultValue(String attrName) {
        int hash = this.hashCode(attrName.toCharArray());
        int i = 0;
        while (i < this.attrNum) {
            AttributeDefinition ad;
            if (this.attributeDefHashes[i] == hash && (ad = this.attributeDefs[i]).getName().equalsIgnoreCase(attrName)) {
                return ad.getDefaultValue();
            }
            ++i;
        }
        return null;
    }

    final boolean exclusion(Element element) {
        if (this.exclusions == null) {
            return false;
        }
        int i = this.exclusions.length - 1;
        while (i >= 0) {
            if (this.exclusions[i].name.equalsIgnoreCase(element.getNodeName())) {
                return true;
            }
            --i;
        }
        return false;
    }

    final boolean inclusion(Element element) {
        if (this.inclusions == null) {
            return false;
        }
        int i = this.inclusions.length - 1;
        while (i >= 0) {
            if (this.inclusions[i].name.equalsIgnoreCase(element.getNodeName())) {
                return true;
            }
            --i;
        }
        return false;
    }

    public final String getName() {
        return this.name;
    }

    final boolean instance(Node node) {
        return node instanceof Element && node.getNodeName().equalsIgnoreCase(this.name);
    }

    final void setContentModel(IModelGroup arg) {
        this.contentModel = arg;
    }

    final void setEndTag(boolean end) {
        this.end = end;
    }

    final void setExclusion(ElementDefinition[] exclusions) {
        this.exclusions = exclusions;
    }

    final void setInclusion(ElementDefinition[] inclusions) {
        this.inclusions = inclusions;
    }

    final void setStartTag(boolean start) {
        this.start = start;
    }

    public final boolean startTagOmittable() {
        return this.start;
    }

    public String toString() {
        String ret = "<!ELEMENT " + this.name + ' ' + (this.start ? (char)'O' : '-') + ' ' + (this.end ? (char)'O' : '-') + ' ' + '>';
        return ret;
    }

    public AttributeDefinition getAttributeDef(String attrName) {
        int hash = this.hashCode(attrName.toCharArray());
        int i = this.attrNum - 1;
        while (i >= 0) {
            if (this.attributeDefHashes[i] == hash && this.attributeDefs[i].getName().equalsIgnoreCase(attrName)) {
                return this.attributeDefs[i];
            }
            --i;
        }
        return null;
    }

    private int hashCode(char[] key) {
        int ret = 0;
        int i = key.length - 1;
        while (i >= 0) {
            ret = 25 * ret + (key[i] & 0x1F) - 1;
            --i;
        }
        return ret;
    }

    public boolean optional() {
        return false;
    }

    public void refer(boolean infinite) {
        if (infinite) {
            this.infinite = infinite;
        } else {
            ++this.refercount;
        }
        if (this.inclusions != null) {
            int i = 0;
            while (i < this.inclusions.length) {
                this.inclusions[i].refer(true);
                ++i;
            }
        }
        if (this.contentModel != null) {
            this.contentModel.refer(infinite);
        }
    }

    public boolean isSingleton() {
        return !this.infinite;
    }

    public int getMagicNumber() {
        return this.number;
    }

    public boolean match(int number) {
        return this.hash[number];
    }

    final boolean[] getInclusionVector() {
        return this.inclusionVector;
    }

    final boolean inclusion(int elementNumber) {
        return this.inclusionVector[elementNumber];
    }

    final boolean[] getExclusionVector() {
        return this.exclusionVector;
    }

    final boolean exclusion(int elementNumber) {
        return this.exclusionVector[elementNumber];
    }

    public boolean[] rehash(int totalSize) {
        int i;
        if (this.hash != null) {
            return this.hash;
        }
        this.inclusionVector = new boolean[totalSize];
        if (this.inclusions != null) {
            i = 0;
            while (i < this.inclusions.length) {
                this.inclusionVector[this.inclusions[i].number] = true;
                ++i;
            }
        }
        this.exclusionVector = new boolean[totalSize];
        if (this.exclusions != null) {
            i = 0;
            while (i < this.exclusions.length) {
                this.exclusionVector[this.exclusions[i].number] = true;
                ++i;
            }
        }
        this.hash = new boolean[totalSize];
        boolean[] contentModelHash = this.contentModel.rehash(totalSize);
        if (this.start) {
            if (contentModelHash == null) {
                contentModelHash = new boolean[totalSize];
            }
            int i2 = totalSize - 1;
            while (i2 >= 0) {
                this.hash[i2] = (this.inclusionVector[i2] | contentModelHash[i2]) & !this.exclusionVector[i2];
                --i2;
            }
        }
        this.hash[this.number] = true;
        return this.hash;
    }
}

