/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32.comclutch;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.actf.util.win32.comclutch.IResource;

public class ResourceManager {
    private final ResourceManager parent;
    private ArrayList<ResourceManager> childRMs;
    private static final int HASHSIZE = 8191;
    private WeakReference<IResource>[] resourceHashArray = new WeakReference[8191];

    public IResource findInResource(long ptr) {
        int idx = (int)ptr % 8191;
        WeakReference<IResource> wr = this.resourceHashArray[idx];
        if (wr == null) {
            return null;
        }
        IResource r = (IResource)wr.get();
        if (r == null) {
            return null;
        }
        if (r.getPtr() == ptr) {
            return r;
        }
        return null;
    }

    public void releaseAll(IResource except) {
        int len = this.resourceHashArray.length;
        int i = 0;
        while (i < len) {
            WeakReference<IResource> wr = this.resourceHashArray[i];
            if (wr != null) {
                this.resourceHashArray[i] = null;
                IResource r = (IResource)wr.get();
                if (r != null) {
                    r.release();
                }
            }
            ++i;
        }
        this.addResource(except);
        if (this.childRMs != null) {
            Iterator<ResourceManager> itm = this.childRMs.iterator();
            while (itm.hasNext()) {
                itm.next().releaseAll(except);
            }
        }
    }

    public void removeResource(IResource resource) {
        long ptr = resource.getPtr();
        int idx = (int)ptr % 8191;
        WeakReference<IResource> wr = this.resourceHashArray[idx];
        if (wr == null) {
            return;
        }
        IResource r = (IResource)wr.get();
        if (r == null) {
            this.resourceHashArray[idx] = null;
            return;
        }
        if (r.getPtr() != ptr) {
            return;
        }
        this.resourceHashArray[idx] = null;
        wr.clear();
    }

    public void addResource(IResource target) {
        long ptr = target.getPtr();
        int idx = (int)ptr % 8191;
        WeakReference<IResource> wr = new WeakReference<IResource>(target);
        this.resourceHashArray[idx] = wr;
    }

    public static ResourceManager newResourceManager(ResourceManager parent) {
        ResourceManager rm = new ResourceManager(parent);
        if (parent != null) {
            if (parent.childRMs == null) {
                parent.childRMs = new ArrayList(1);
            }
            parent.childRMs.add(rm);
        }
        return rm;
    }

    private ResourceManager(ResourceManager parent) {
        this.parent = parent;
    }
}

