/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.internal.ui.editors.ie.CurrentStylesImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEImpl;
import org.eclipse.actf.model.ui.ModelServiceSizeInfo;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserStyleInfo;
import org.eclipse.actf.util.dom.TreeWalkerImpl;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBrowserStyleInfoImpl
implements IWebBrowserStyleInfo {
    private static final String TAG_HEAD = "HEAD";
    private final WebBrowserIEImpl browser;

    public WebBrowserStyleInfoImpl(WebBrowserIEImpl browser) {
        this.browser = browser;
    }

    public HashMap<String, ICurrentStyles> getCurrentStyles() {
        HashMap<String, ICurrentStyles> currentStyles = new HashMap<String, ICurrentStyles>(512);
        Document doc = this.browser.getLiveDocument();
        TreeWalkerImpl treeWalker = new TreeWalkerImpl((Node)doc, 1, new NodeFilter(){

            public short acceptNode(Node arg0) {
                if (WebBrowserStyleInfoImpl.TAG_HEAD.equalsIgnoreCase(arg0.getNodeName())) {
                    return 2;
                }
                return 1;
            }
        }, false);
        Node tmpN = treeWalker.nextNode();
        URL base = null;
        try {
            base = new URL(this.browser.getURL());
        }
        catch (MalformedURLException malformedURLException) {}
        while (tmpN != null) {
            if (tmpN instanceof IElementEx) {
                CurrentStylesImpl curStyle = new CurrentStylesImpl((IElementEx)tmpN, base);
                currentStyles.put(curStyle.getXPath(), curStyle);
            }
            tmpN = treeWalker.nextNode();
        }
        return currentStyles;
    }

    public RGB getUnvisitedLinkColor() {
        return this.browser.getAnchorColor();
    }

    public RGB getVisitedLinkColor() {
        return this.browser.getVisitedAnchorColor();
    }

    public ModelServiceSizeInfo getSizeInfo(boolean isWhole) {
        return this.browser.getBrowserSize(isWhole);
    }
}

