/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.msp.engine;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.actf.ai.tts.ISAPIEngine;
import org.eclipse.actf.ai.tts.ITTSEngineInfo;
import org.eclipse.actf.ai.tts.msp.MspPlugin;
import org.eclipse.actf.ai.tts.msp.engine.ISpNotifySource;
import org.eclipse.actf.ai.tts.msp.engine.ISpVoice;
import org.eclipse.actf.ai.tts.msp.engine.SpObjectToken;
import org.eclipse.actf.ai.tts.msp.engine.SpeechObjectTokens;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.util.win32.COMUtil;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MspVoice
implements ISAPIEngine,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.actf.ai.tts.msp.engine.MspVoice";
    public static final String AUDIO_OUTPUT = "org.eclipse.actf.ai.tts.MspVoice.audioOutput";
    public static final GUID IID_SpFileStream = COMUtil.IIDFromString((String)"{947812B3-2AE1-4644-BA86-9E90DED7EC91}");
    public ISpVoice dispSpVoice;
    private Variant varSapiVoice;
    private OleAutomation automation;
    private int idGetVoices;
    private int idGetAudioOutputs;
    private ISpNotifySource spNotifySource = null;
    private static IPreferenceStore preferenceStore = MspPlugin.getDefault().getPreferenceStore();
    private boolean isDisposed = false;
    private SpObjectToken curVoiceToken = null;
    private Map<String, TreeSet<EngineInfo>> langId2EngineMap = new HashMap<String, TreeSet<EngineInfo>>();
    private Set<ITTSEngineInfo> ttsEngineInfoSet = new TreeSet<ITTSEngineInfo>(new Comparator<ITTSEngineInfo>(){

        @Override
        public int compare(ITTSEngineInfo o1, ITTSEngineInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    public MspVoice() {
        int pv = COMUtil.createDispatch((GUID)ISpVoice.IID);
        this.dispSpVoice = new ISpVoice(pv);
        this.varSapiVoice = new Variant((IDispatch)this.dispSpVoice);
        this.automation = this.varSapiVoice.getAutomation();
        this.spNotifySource = ISpNotifySource.getNotifySource(this.dispSpVoice);
        MspPlugin.getDefault().addPropertyChangeListener(this);
        this.idGetVoices = this.getIDsOfNames("GetVoices");
        this.idGetAudioOutputs = this.getIDsOfNames("GetAudioOutputs");
        String orgID = preferenceStore.getString(ID);
        preferenceStore.setValue(ID, preferenceStore.getDefaultString(ID));
        this.setAudioOutputName();
        preferenceStore.setValue(ID, orgID);
        this.setVoiceName();
        Variant varVoices = this.getVoices(null, null);
        if (varVoices != null) {
            SpeechObjectTokens voiceTokens = SpeechObjectTokens.getTokens(varVoices);
            if (voiceTokens != null) {
                String exclude = Platform.getResourceString((Bundle)MspPlugin.getDefault().getBundle(), (String)"%voice.exclude");
                int count = voiceTokens.getCount();
                int i = 0;
                while (i < count) {
                    SpObjectToken token;
                    Variant varVoice = voiceTokens.getItem(i);
                    if (varVoice != null && (token = SpObjectToken.getToken(varVoice)) != null) {
                        String voiceName = token.getDescription(0);
                        String langId = token.getAttribute("language");
                        int index = langId.indexOf(";");
                        if (index > 0) {
                            langId = langId.substring(0, index);
                        }
                        String gender = token.getAttribute("gender");
                        if (exclude == null || !exclude.equals(voiceName)) {
                            TreeSet<EngineInfo> set = this.langId2EngineMap.get(langId);
                            if (set == null) {
                                set = new TreeSet<EngineInfo>(new Comparator<EngineInfo>(){

                                    @Override
                                    public int compare(EngineInfo o1, EngineInfo o2) {
                                        return -o1.name.compareTo(o2.name);
                                    }
                                });
                                this.langId2EngineMap.put(langId, set);
                            }
                            String lang = (String)LANGID_REVERSE_MAP.get(langId);
                            EngineInfo engineInfo = new EngineInfo(voiceName, lang, langId, gender);
                            set.add(engineInfo);
                            this.ttsEngineInfoSet.add(engineInfo);
                        }
                    }
                    ++i;
                }
            }
            varVoices.dispose();
        }
        this.stop();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (ID.equals(event.getProperty())) {
            this.stop();
            this.setVoiceName();
        } else if (AUDIO_OUTPUT.equals(event.getProperty())) {
            this.stop();
            this.setAudioOutputName();
        }
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        this.spNotifySource.setEventListener(eventListener);
    }

    public void speak(String text, int flags, int index) {
        int firstFlag = 1;
        if ((1 & flags) != 0) {
            firstFlag |= 2;
        }
        if (index >= 0) {
            this.speak("<BOOKMARK mark=\"" + index + "\"/>", firstFlag | 0x20);
            this.speak(text, 1);
            this.speak("<BOOKMARK mark=\"-1\"/>", 33);
        } else {
            this.speak(text, firstFlag);
        }
    }

    public void speak(String text, int sapiFlags) {
        char[] data = (String.valueOf(text) + "\u0000").toCharArray();
        int bstrText = MemoryUtil.SysAllocString((char[])data);
        try {
            this.dispSpVoice.Speak(bstrText, sapiFlags);
        }
        finally {
            MemoryUtil.SysFreeString((int)bstrText);
        }
    }

    public void stop() {
        this.speak("", 1, -1);
    }

    public boolean setRate(int rate) {
        return this.dispSpVoice.put_Rate(rate) == 0;
    }

    public int getRate() {
        NativeIntAccess nia = new NativeIntAccess();
        try {
            if (this.dispSpVoice.get_Rate(nia.getAddress()) == 0) {
                int n = nia.getInt();
                return n;
            }
        }
        finally {
            nia.dispose();
        }
        return -1;
    }

    public boolean setVoice(Variant varVoice) {
        boolean result;
        boolean bl = result = this.dispSpVoice.put_Voice(varVoice.getDispatch().getAddress()) == 0;
        if (result) {
            this.curVoiceToken = SpObjectToken.getToken(varVoice);
        }
        return result;
    }

    public boolean setAudioOutput(Variant varAudioOutput) {
        return this.dispSpVoice.put_AudioOutput(varAudioOutput != null ? varAudioOutput.getDispatch().getAddress() : 0) == 0;
    }

    private void setVoiceName() {
        String voiceName = preferenceStore.getString(ID);
        if (voiceName.length() > 0) {
            this.setVoiceName("name=" + voiceName);
        }
    }

    public boolean setVoiceName(String voiceName) {
        boolean success = false;
        Variant varVoices = this.getVoices(voiceName, null);
        if (varVoices != null) {
            Variant varVoice;
            SpeechObjectTokens tokens = SpeechObjectTokens.getTokens(varVoices);
            if (tokens != null && tokens.getCount() > 0 && (varVoice = tokens.getItem(0)) != null) {
                success = this.setVoice(varVoice);
            }
            varVoices.dispose();
        }
        if (!success) {
            int index = voiceName.indexOf("name=");
            varVoices = this.getVoices(null, null);
            if (varVoices != null && index > -1) {
                String name = voiceName.substring(index + 5);
                SpeechObjectTokens voiceTokens = SpeechObjectTokens.getTokens(varVoices);
                if (voiceTokens != null) {
                    int count = voiceTokens.getCount();
                    int i = 0;
                    while (i < count) {
                        SpObjectToken token;
                        Variant varVoice = voiceTokens.getItem(i);
                        if (varVoice != null && (token = SpObjectToken.getToken(varVoice)) != null && name.equals(token.getDescription(0))) {
                            success = this.setVoice(varVoice);
                        }
                        ++i;
                    }
                }
            }
            varVoices.dispose();
        }
        return success;
    }

    private void setAudioOutputName() {
        String audioOutput = preferenceStore.getString(AUDIO_OUTPUT);
        if (audioOutput.length() > 0) {
            this.setAudioOutputName(audioOutput);
        } else {
            this.setAudioOutput(null);
        }
    }

    public boolean setAudioOutputName(String audioOutput) {
        boolean success = false;
        Variant varAudioOutputs = this.getAudioOutputs(null, null);
        if (varAudioOutputs != null) {
            SpeechObjectTokens tokens = SpeechObjectTokens.getTokens(varAudioOutputs);
            if (tokens != null) {
                int i = 0;
                while (i < tokens.getCount()) {
                    SpObjectToken token;
                    Variant varAudioOutput = tokens.getItem(i);
                    if (varAudioOutput != null && (token = SpObjectToken.getToken(varAudioOutput)) != null && audioOutput.equals(token.getDescription(0))) {
                        success = this.setAudioOutput(varAudioOutput);
                        break;
                    }
                    ++i;
                }
            }
            varAudioOutputs.dispose();
        }
        return success;
    }

    public Variant getVoices(String requiredAttributes, String optionalAttributes) {
        return this.getTokens(this.idGetVoices, requiredAttributes, optionalAttributes);
    }

    public Variant getAudioOutputs(String requiredAttributes, String optionalAttributes) {
        return this.getTokens(this.idGetAudioOutputs, requiredAttributes, optionalAttributes);
    }

    private Variant getTokens(int id, String requiredAttributes, String optionalAttributes) {
        if (requiredAttributes == null) {
            return this.automation.invoke(id);
        }
        if (optionalAttributes == null) {
            return this.automation.invoke(id, new Variant[]{new Variant(requiredAttributes)});
        }
        return this.automation.invoke(id, new Variant[]{new Variant(requiredAttributes), new Variant(optionalAttributes)});
    }

    private int getIDsOfNames(String name) {
        int[] dispid = this.automation.getIDsOfNames(new String[]{name});
        if (dispid != null) {
            return dispid[0];
        }
        return 0;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.varSapiVoice.dispose();
            if (MspPlugin.getDefault() != null) {
                MspPlugin.getDefault().removePropertyChangeListener(this);
            }
        }
    }

    public int getSpeed() {
        int rate = this.getRate();
        return (rate + 10) * 5;
    }

    public void setSpeed(int speed) {
        int rate = speed / 5 - 10;
        this.setRate(rate);
    }

    public void setLanguage(String language) {
        String gender = null;
        if (this.curVoiceToken != null) {
            gender = this.curVoiceToken.getAttribute("gender");
        }
        gender = gender == null ? "" : "gender=" + gender;
        String langId = (String)LANGID_MAP.get(language);
        if (langId == null) {
            if ("ja".equals(language)) {
                langId = "411";
            } else if ("en".equals(language)) {
                langId = "409";
            }
        }
        if (langId == null) {
            return;
        }
        String lang = "language=" + langId + ";";
        Variant varVoices = this.getVoices(String.valueOf(lang) + gender, null);
        if (varVoices == null && gender.length() > 0) {
            varVoices = this.getVoices(lang, null);
        }
        if (varVoices != null) {
            Variant varVoice;
            SpeechObjectTokens tokens = SpeechObjectTokens.getTokens(varVoices);
            if (tokens != null && tokens.getCount() > 0 && (varVoice = tokens.getItem(0)) != null) {
                this.setVoice(varVoice);
            }
            varVoices.dispose();
        }
    }

    public void setGender(String gender) {
        if (gender == null) {
            return;
        }
        String langId = null;
        if (this.curVoiceToken != null && "409;9".equals(langId = this.curVoiceToken.getAttribute("language"))) {
            langId = "409";
        }
        Variant varVoices = null;
        String lang = "";
        if (langId != null) {
            lang = "language=" + langId + ";";
        }
        if ("male".equalsIgnoreCase(gender)) {
            varVoices = this.getVoices(String.valueOf(lang) + "gender=Male", null);
        } else if ("female".equalsIgnoreCase(gender)) {
            varVoices = this.getVoices(String.valueOf(lang) + "gender=Female", null);
        }
        if (varVoices != null) {
            Variant varVoice;
            SpeechObjectTokens tokens = SpeechObjectTokens.getTokens(varVoices);
            if (tokens != null && tokens.getCount() > 0 && (varVoice = tokens.getItem(0)) != null) {
                this.setVoice(varVoice);
            }
            varVoices.dispose();
        }
    }

    public boolean isAvailable() {
        return this.automation != null;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public boolean canSpeakToFile() {
        return true;
    }

    public boolean speakToFile(String text, File file) {
        boolean speakToFileResult;
        block8: {
            int pv = COMUtil.createDispatch((GUID)IID_SpFileStream);
            OleAutomation autoSpFileStream = null;
            speakToFileResult = false;
            if (file == null || file.exists() && !file.canWrite()) {
                return false;
            }
            Variant varSpFileStream = new Variant(new IDispatch(pv));
            try {
                autoSpFileStream = varSpFileStream.getAutomation();
                String tmpS = file.toURI().toString();
                if (tmpS.startsWith("file:/")) {
                    tmpS = tmpS.substring(6).replaceAll("%20", " ");
                }
                autoSpFileStream.invoke(100, new Variant[]{new Variant(tmpS), new Variant(3), new Variant(false)});
                this.dispSpVoice.put_AudioOutputStream(pv);
                char[] data = (String.valueOf(text) + "\u0000").toCharArray();
                int bstrText = MemoryUtil.SysAllocString((char[])data);
                try {
                    this.dispSpVoice.Speak(bstrText, 0);
                }
                finally {
                    MemoryUtil.SysFreeString((int)bstrText);
                }
                autoSpFileStream.invoke(101);
                autoSpFileStream.dispose();
                autoSpFileStream = null;
                speakToFileResult = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (autoSpFileStream == null) break block8;
                autoSpFileStream.dispose();
                autoSpFileStream = null;
            }
        }
        this.setAudioOutputName();
        return speakToFileResult;
    }

    public Set<ITTSEngineInfo> getTTSEngineInfoSet() {
        return this.ttsEngineInfoSet;
    }

    private class EngineInfo
    implements ITTSEngineInfo {
        String name;
        String lang;
        String langId;
        String gender;

        public EngineInfo(String name, String lang, String langId, String gender) {
            this.name = name;
            this.lang = lang;
            this.langId = langId;
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public String getLanguage() {
            return this.lang;
        }

        public String getGender() {
            return this.gender;
        }
    }
}

