/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.flash.FlashPlayerFactory;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.util.win32.FlashMSAAObject;
import org.eclipse.actf.util.win32.FlashMSAAObjectFactory;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.util.win32.comclutch.ComService;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IServiceProvider;
import org.eclipse.actf.util.win32.comclutch.IUnknown;

public class FlashMSAAUtil {
    private static boolean SCAN_ALL = false;
    private static boolean SHOW_OFFSCREEN = false;

    public static boolean isFlash(int iacc) {
        FlashMSAAObject acc = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)iacc);
        return FlashMSAAUtil.isFlash(acc);
    }

    public static boolean isInvisibleFlash(int iacc) {
        FlashMSAAObject acc = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)iacc);
        return FlashMSAAUtil.isInvisibleFlash(acc);
    }

    public static IFlashPlayer[] getFlashPlayers(int hwnd) {
        return FlashMSAAUtil.getFlashPlayers(hwnd, SHOW_OFFSCREEN, SCAN_ALL);
    }

    public static IFlashPlayer[] getFlashPlayers(int hwnd, boolean showOffScreen, boolean scanAll) {
        FlashMSAAObject acc = FlashMSAAObjectFactory.getFlashMSAAObjectFromWindow((long)hwnd);
        FlashMSAAObject[] accs = FlashMSAAUtil.getFlashElements(acc, showOffScreen, scanAll);
        IFlashPlayer[] ret = new IFlashPlayer[accs.length];
        int i = 0;
        while (i < accs.length) {
            ret[i] = FlashPlayerFactory.getPlayerFromObject(accs[i]);
            ++i;
        }
        return ret;
    }

    public static boolean isFlash(FlashMSAAObject accObject) {
        return FlashMSAAUtil.isFlashClass(accObject.getClassName()) || FlashMSAAUtil.isInvisibleFlash(accObject);
    }

    public static boolean isInvisibleFlash(FlashMSAAObject accObject) {
        String description;
        if (10 == accObject.getAccRole() && (description = accObject.getAccDescription()) != null && description.startsWith("PLUGIN: type=")) {
            return FlashMSAAUtil.getHtmlAttribute(accObject, "WMode") != null;
        }
        return false;
    }

    public static boolean isFlashClass(String className) {
        return "MacromediaFlashPlayerActiveX".equals(className) || "ShockwaveFlashPlugin".equals(className);
    }

    public static FlashMSAAObject[] getFlashElements(FlashMSAAObject root) {
        return FlashMSAAUtil.getFlashElements(root, SHOW_OFFSCREEN, SCAN_ALL);
    }

    public static FlashMSAAObject[] getFlashElements(FlashMSAAObject root, boolean showOffScreen, boolean scanAll) {
        FlashFinder finder = new FlashFinder();
        finder.find(root, showOffScreen, scanAll);
        return finder.getResults();
    }

    public static boolean isScanAll() {
        return SCAN_ALL;
    }

    public static void setScanAll(boolean scan_all) {
        SCAN_ALL = scan_all;
    }

    public static boolean isShowOffscreen() {
        return SHOW_OFFSCREEN;
    }

    public static void setShowOffscreen(boolean show_offscreen) {
        SHOW_OFFSCREEN = show_offscreen;
    }

    public static IDispatch getHtmlElementFromPtr(int iacc) {
        FlashMSAAObject acc = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)iacc);
        return FlashMSAAUtil.getHtmlElementFromObject(acc);
    }

    public static String getHtmlAttribute(int iacc, String name) {
        FlashMSAAObject acc = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)iacc);
        return FlashMSAAUtil.getHtmlAttribute(acc, name);
    }

    public static IDispatch getHtmlElementFromObject(Object objUnknown) {
        if (objUnknown instanceof FlashMSAAObject) {
            objUnknown = ((FlashMSAAObject)objUnknown).getIAccessible();
        }
        if (objUnknown instanceof IUnknown) {
            IServiceProvider sp = (IServiceProvider)((IUnknown)objUnknown).queryInterface(IUnknown.IID_IServiceProvider);
            if (sp == null) {
                return null;
            }
            IUnknown idisp = null;
            try {
                idisp = sp.queryService(IUnknown.IID_IHTMLElement, IUnknown.IID_IHTMLElement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idisp == null) {
                return null;
            }
            return ComService.newIDispatch((IUnknown)idisp);
        }
        return null;
    }

    private static String getHtmlAttribute(Object objUnknown, String name) {
        IDispatch varElement = FlashMSAAUtil.getHtmlElementFromObject(objUnknown);
        if (varElement == null) {
            return null;
        }
        try {
            return (String)varElement.get(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class FlashFinder {
        private boolean showOffScreen = false;
        private List<FlashMSAAObject> result = new ArrayList<FlashMSAAObject>();

        private FlashFinder() {
        }

        public void find(FlashMSAAObject accObject, boolean showOffScreen, boolean scanAll) {
            this.showOffScreen = showOffScreen;
            if (scanAll || FlashFinder.findFlashWindow(accObject.getWindow()) != 0) {
                this.findChildren(accObject);
            }
        }

        private static int findFlashWindow(int hwnd) {
            if (hwnd != 0) {
                if (FlashMSAAUtil.isFlashClass(WindowUtil.GetWindowClassName((int)hwnd))) {
                    return hwnd;
                }
                int hwndChild = WindowUtil.GetChildWindow((int)hwnd);
                while (hwndChild != 0) {
                    int hwndFound = FlashFinder.findFlashWindow(hwndChild);
                    if (hwndFound != 0) {
                        return hwndFound;
                    }
                    hwndChild = WindowUtil.GetNextWindow((int)hwndChild);
                }
            }
            return 0;
        }

        private void findChildren(FlashMSAAObject[] inputElements) {
            int i = 0;
            while (i < inputElements.length) {
                this.findChildren(inputElements[i]);
                ++i;
            }
        }

        private void findChildren(FlashMSAAObject accObject) {
            if (accObject != null) {
                int role = accObject.getAccRole();
                if ((9 == role || 10 == role) && FlashMSAAUtil.isFlash(accObject)) {
                    this.result.add(accObject);
                } else {
                    switch (accObject.getAccState() & 0x18000) {
                        case 98304: {
                            if (!this.showOffScreen) break;
                        }
                        case 0: {
                            this.findChildren(accObject.getChildren());
                        }
                    }
                }
            }
        }

        public FlashMSAAObject[] getResults() {
            FlashMSAAObject[] resultArray = new FlashMSAAObject[this.result.size()];
            return this.result.toArray(resultArray);
        }
    }
}

