/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;

public class SwfHeaderParser {
    private static final Logger LOGGER = Logger.getLogger(SwfHeaderParser.class.getName());
    private static int COMPRESSED_FLAG = 67;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int byteCount = 0;
    private byte[] buf1 = new byte[8];
    private byte[] buf2 = new byte[17];
    private byte[] buf3 = new byte[4];
    private InputStream in;
    private boolean isCompressed = false;
    private int version;
    private int length;
    private int frameSizeX;
    private int frameSizeY;
    private int rate;
    private int framecount;

    public SwfHeaderParser(InputStream _in) {
        this.in = _in;
    }

    private int readSBits(int numBits) throws IOException {
        if (numBits > 32) {
            throw new IOException("Number of bits > 32");
        }
        int num = this.readUBits(numBits);
        int shift = 32 - numBits;
        num = num << shift >> shift;
        return num;
    }

    private int readUBits(int numBits) throws IOException {
        int shift;
        byte[] buf;
        if (numBits == 0) {
            return 0;
        }
        int bitsLeft = numBits;
        int result = 0;
        if (this.bitPos == 0) {
            buf = new byte[1];
            this.in.read(buf);
            this.buf2[this.byteCount] = buf[0];
            ++this.byteCount;
            this.bitBuf = buf[0] & 0xFF;
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            buf = new byte[1];
            this.in.read(buf);
            this.buf2[this.byteCount] = buf[0];
            ++this.byteCount;
            this.bitBuf = buf[0] & 0xFF;
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public void parse() throws IOException {
        LOGGER.fine("skipping header...");
        this.in.read(this.buf1);
        if (this.buf1[0] == COMPRESSED_FLAG) {
            this.isCompressed = true;
        }
        LOGGER.fine("compressed=" + this.isCompressed);
        this.version = this.buf1[3] & 0xFF;
        LOGGER.fine("version=" + this.version);
        this.length = this.buf1[4] & 0xFF | (this.buf1[5] & 0xFF) << 8 | (this.buf1[6] & 0xFF) << 16 | this.buf1[7] << 24;
        LOGGER.fine("length=" + this.length);
        if (this.isCompressed) {
            this.in = new InflaterInputStream(this.in);
        }
        this.readFrameSize();
        this.in.read(this.buf3);
        this.rate = (this.buf3[0] & 0xFF) << 8 | this.buf3[1] & 0xFF;
        this.framecount = this.buf3[2] & 0xFF | (this.buf3[3] & 0xFF) << 8;
        LOGGER.fine("rate=" + this.rate + ", framecount=" + this.framecount);
    }

    private void readFrameSize() throws IOException {
        int nBits = this.readUBits(5);
        LOGGER.fine("frame size X min = " + Integer.toString(this.readSBits(nBits)));
        this.frameSizeX = this.readSBits(nBits);
        LOGGER.fine("frame size X max (twips) = " + Integer.toString(this.frameSizeX));
        LOGGER.fine("frame size Y min = " + Integer.toString(this.readSBits(nBits)));
        this.frameSizeY = this.readSBits(nBits);
        LOGGER.fine("frame size Y max (twips) = " + Integer.toString(this.frameSizeY));
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public int getFrameSizeX() {
        return this.frameSizeX;
    }

    public int getFrameSizeY() {
        return this.frameSizeY;
    }

    public InputStream getInputStream() {
        return this.in;
    }
}

