/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.eclipse.actf.model.internal.flash.proxy.SWFUtil;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServer;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyConnection;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoder;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.httpproxy.util.HTTPUtil;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.httpproxy.util.ParseURI;

public class HTTPLocalServerSWF
implements IHTTPLocalServer {
    private static final String OK = "OK";
    private static final String RESPONSE_200 = "200";
    private static final boolean LOCAL_FILE_ACCESS = false;
    private static final int HTTP_WELL_KNOWN_PORT = 80;
    private static final byte[] MIME_TYPE_APPLICATION_XML_A = "application/xml".getBytes();
    private static final Logger LOGGER = Logger.getLogger(HTTPLocalServerSWF.class);
    private static HashMap<String, MIMEType> mimeTypeMap = new HashMap();
    private static byte[] bridgeInitSwf;
    private static byte[] bridgeInitSwfV9;
    private int swfORBPort = -1;

    public static void addMIMEType(String suffix, String type, String subtype) {
        mimeTypeMap.put(suffix, new MIMEType(suffix, type, subtype));
    }

    public static MIMEType getMIMEType(String suffix) {
        return mimeTypeMap.get(suffix);
    }

    private static byte[] readBridgeSWFFile(InputStream is) {
        try {
            int b;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((b = is.read()) >= 0) {
                os.write(b);
            }
            return os.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static void setBridgeInitSwf(InputStream is) {
        bridgeInitSwf = HTTPLocalServerSWF.readBridgeSWFFile(is);
    }

    public static void setBridgeInitSwfV9(InputStream is) {
        bridgeInitSwfV9 = HTTPLocalServerSWF.readBridgeSWFFile(is);
    }

    private IHTTPResponseMessage processBridgeInitSwf(IHTTPRequestMessage request) {
        IHTTPResponseMessage response = HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])bridgeInitSwf);
        response.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return response;
    }

    private IHTTPResponseMessage processBridgeInitSwfV9(IHTTPRequestMessage request) {
        IHTTPResponseMessage response = HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])bridgeInitSwfV9);
        response.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return response;
    }

    private IHTTPResponseMessage processLoadVarsForSwf(IHTTPRequestMessage request, ISecretManager secretManager) {
        IHTTPResponseMessage response = HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])secretManager.requestSecret());
        response.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_WWW_FORM_URLENCODED_A);
        return response;
    }

    private IHTTPResponseMessage processSwfCrossDomainPolicyFile(IHTTPRequestMessage request) {
        LOGGER.info("Request crossdomain.xml policy file.");
        String contents = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<cross-domain-policy><allow-access-from domain=\"*\"/></cross-domain-policy>\n";
        IHTTPResponseMessage response = HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])contents.getBytes());
        response.setHeader(IHTTPHeader.CONTENT_TYPE_A, MIME_TYPE_APPLICATION_XML_A);
        return response;
    }

    private IHTTPResponseMessage processLocalFile(int id, IHTTPRequestMessage request, String absPath, IHTTPProxyTranscoder transcoder) {
        String suffix;
        MIMEType mt;
        int sPos;
        try {
            absPath = URLDecoder.decode(absPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        LOGGER.info("Local Server Mode. Send:" + absPath);
        File f = new File(absPath);
        if (!f.canRead()) {
            return null;
        }
        int len = (int)f.length();
        byte[] contents = new byte[len];
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(f);
                is.read(contents, 0, len);
            }
            catch (Exception exception) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        IHTTPResponseMessage response = HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])contents);
        int dotPos = absPath.lastIndexOf(".");
        if (dotPos > 0 && dotPos > (sPos = absPath.lastIndexOf("/")) && (mt = HTTPLocalServerSWF.getMIMEType(suffix = absPath.substring(dotPos + 1))) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(mt.type).append('/').append(mt.subtype);
            response.setHeader(IHTTPHeader.CONTENT_TYPE_A, sb.toString().getBytes());
        }
        if (transcoder != null) {
            response = transcoder.transcode(id, request, response);
        }
        return response;
    }

    public boolean processRequest(int id, IHTTPProxyConnection fClient, IHTTPRequestMessage request, IHTTPProxyTranscoder transcoder) throws InterruptedException, IOException {
        String hostStr;
        if (!"GET".equals(request.getMethodAsString())) {
            return false;
        }
        String uriStr = request.getRequestURIString();
        String authority = ParseURI.getAuthority((String)uriStr);
        String absPath = ParseURI.getAbsolutePath((String)uriStr);
        if (authority != null) {
            hostStr = authority;
        } else {
            IHTTPHeader hostHeader = request.getHeader(IHTTPHeader.HOST_A);
            if (hostHeader == null) {
                return false;
            }
            hostStr = new String(hostHeader.getValue());
        }
        String host = ParseURI.parseHost((String)hostStr);
        int port = ParseURI.parsePort((String)hostStr, (int)80);
        IHTTPResponseMessage response = null;
        if (absPath.endsWith("Eclipse-ACTF-SWF-Initialize-Bridge-Package-1082017309130187472.swf")) {
            response = this.processBridgeInitSwf(request);
        } else if (absPath.endsWith("bridge_as3.swf")) {
            response = this.processBridgeInitSwfV9(request);
        } else if (absPath.endsWith("Eclipse-ACTF-SWF-LoadVars-1082017309130187472.txt")) {
            response = this.processLoadVarsForSwf(request, fClient.getSecretManager());
        } else {
            if (!"localhost".equals(host)) {
                return false;
            }
            if (port == 80 && "/crossdomain.xml".equals(absPath)) {
                response = this.processSwfCrossDomainPolicyFile(request);
            } else {
                return false;
            }
        }
        if (response == null) {
            HTTPUtil.sendFailedToClient((IHTTPProxyConnection)fClient, (IHTTPRequestMessage)request);
            return true;
        }
        try {
            fClient.sendResponse(0L, response);
        }
        catch (TimeoutException e) {
            LOGGER.fatal("Timeout in local server mode", (Throwable)e);
        }
        return true;
    }

    public int getSwfORBPort() {
        if (this.swfORBPort < 0) {
            throw new IllegalStateException("swfORBPort is not set");
        }
        return this.swfORBPort;
    }

    public void setSwfORBPort(int swfORBPort) {
        this.swfORBPort = swfORBPort;
    }

    public HTTPLocalServerSWF() {
        HTTPLocalServerSWF.addMIMEType("html", "text", "html");
        HTTPLocalServerSWF.addMIMEType("htm", "text", "html");
        HTTPLocalServerSWF.addMIMEType("js", "application", "x-javascript");
        HTTPLocalServerSWF.addMIMEType("swf", "application", "x-shockwave-flash");
        HTTPLocalServerSWF.addMIMEType("gif", "image", "gif");
        HTTPLocalServerSWF.addMIMEType("jpeg", "image", "jpeg");
        HTTPLocalServerSWF.addMIMEType("jpg", "image", "jpeg");
        HTTPLocalServerSWF.addMIMEType("png", "image", "png");
    }

    public static class MIMEType {
        public final String suffix;
        public final String type;
        public final String subtype;

        MIMEType(String suffix, String type, String subtype) {
            this.suffix = suffix;
            this.type = type;
            this.subtype = subtype;
        }
    }
}

