/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.eval;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.ui.util.HighlightStringListener;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.BlindVizEnginePlugin;
import org.eclipse.actf.visualization.internal.engines.blind.Messages;
import org.eclipse.actf.visualization.internal.engines.blind.SummaryEvaluation;
import org.eclipse.actf.visualization.util.RadarChart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEvaluation {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private PageData pageData;
    private String[] metrics = this.guidelineHolder.getMetricsNames();
    private String[] lMetrics = this.guidelineHolder.getLocalizedMetricsNames();
    private int metricsSize = this.metrics.length;
    private int[] scores = new int[this.metricsSize];

    public static HighlightStringListener getHighLightStringListener() {
        HighlightStringListener hlsl = new HighlightStringListener();
        Color blue = Display.getDefault().getSystemColor(9);
        Color red = Display.getDefault().getSystemColor(3);
        if (Display.getDefault().getHighContrast()) {
            blue = null;
            red = null;
        }
        hlsl.addTarget(Messages.Eval_excellent, blue, 1);
        hlsl.addTarget(Messages.Eval_completely_compliant, blue, 1);
        hlsl.addTarget(Messages.Eval_completely_compliant_with_user_check_items, blue, 1);
        hlsl.addTarget(Messages.Eval_compliant_with_some_other_errors, red, 1);
        hlsl.addTarget(Messages.Eval_some_errors_on_metrics, red, 1);
        hlsl.addTarget(Messages.Eval_many_accessibility_issues, red, 1);
        hlsl.addTarget(Messages.Eval_some_accessibility_issues, red, 1);
        hlsl.addTarget(Messages.Eval_easy_for_blind_user_to_navigate, blue, 1);
        hlsl.addTarget(Messages.Eval_page_has_skiplinks_headings, red, 1);
        hlsl.addTarget(Messages.Eval_darkcolored_visualization_view, red, 1);
        return hlsl;
    }

    public PageEvaluation(List<IProblemItem> problems, PageData pageData) {
        this.pageData = pageData;
        Arrays.fill(this.scores, 100);
        this.createPageReport(problems, pageData);
    }

    private void addProblem(IProblemItem item) {
        int[] curScores = item.getEvaluationItem().getMetricsScores();
        if (curScores.length == this.metricsSize) {
            int i = 0;
            while (i < this.metricsSize) {
                int n = i;
                this.scores[n] = this.scores[n] - curScores[i];
                ++i;
            }
        }
    }

    private void checkMinus() {
        int i = 0;
        while (i < this.metricsSize) {
            if (this.scores[i] < 0) {
                this.scores[i] = 0;
            }
            ++i;
        }
    }

    private void setInvalidLinkRatio(double ratio) {
    }

    protected boolean hasComplianceError() {
        int i = 0;
        while (i < this.metricsSize) {
            if ((this.metrics[i].equalsIgnoreCase("perceivable") || this.metrics[i].equalsIgnoreCase("understandable") || this.metrics[i].equalsIgnoreCase("robust") || this.metrics[i].equalsIgnoreCase("operable")) && this.scores[i] != 100) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getAllResult() {
        Vector<String> tmpV = new Vector<String>();
        tmpV.add("Page Rating");
        tmpV.add(this.getOverallRating());
        boolean[] enabledMetrics = this.guidelineHolder.getMatchedMetrics();
        int i = 0;
        while (i < this.metricsSize) {
            if (enabledMetrics[i]) {
                tmpV.add(this.lMetrics[i]);
                tmpV.add(String.valueOf(this.scores[i]));
            }
            ++i;
        }
        String[] result = new String[tmpV.size()];
        tmpV.toArray(result);
        return result;
    }

    private int getMinScore() {
        int minValue = 100;
        boolean[] enabled = GuidelineHolder.getInstance().getMatchedMetrics();
        int i = 0;
        while (i < this.metricsSize) {
            if (enabled[i] && minValue > this.scores[i]) {
                minValue = this.scores[i];
            }
            ++i;
        }
        return minValue;
    }

    public String getOverallRating() {
        int minValue = this.getMinScore();
        String rating = Messages.PageEvaluation_Bad;
        if (minValue == 100) {
            rating = Messages.PageEvaluation_Excellent;
        } else if (minValue >= 75) {
            rating = Messages.PageEvaluation_Good;
        } else if (minValue >= 50) {
            rating = Messages.PageEvaluation_Poor;
        }
        return rating;
    }

    public String getSummary() {
        SummaryEvaluation se = new SummaryEvaluation(this, this.pageData, this.hasComplianceError());
        return se.getOverview();
    }

    public String getRatingIcon() {
        int minValue = this.getMinScore();
        String rating = "Bad.png";
        if (minValue == 100) {
            rating = "VeryGood.png";
        } else if (minValue >= 75) {
            rating = "Good.png";
        } else if (minValue >= 50) {
            rating = "Poor.png";
        }
        return rating;
    }

    private void createPageReport(List<IProblemItem> problems, PageData pageData) {
        for (IProblemItem item : problems) {
            this.addProblem(item);
        }
        this.setInvalidLinkRatio(pageData.getInvalidLinkRatio());
        this.checkMinus();
        boolean[] enabled = GuidelineHolder.getInstance().getMatchedMetrics();
        String[] metrics = this.lMetrics;
        int[] scores = this.getScores();
        Vector<String> metricsV = new Vector<String>();
        Vector<Integer> scoresV = new Vector<Integer>();
        int i = 0;
        while (i < enabled.length) {
            if (enabled[i]) {
                metricsV.add(metrics[i]);
                scoresV.add(new Integer(scores[i]));
            }
            ++i;
        }
        metrics = new String[metricsV.size()];
        metricsV.toArray(metrics);
        scores = new int[scoresV.size()];
        i = 0;
        while (i < scoresV.size()) {
            scores[i] = (Integer)scoresV.get(i);
            ++i;
        }
        try {
            RadarChart chart = new RadarChart(metrics, scores);
            chart.writeToPNG(new File(BlindVizEnginePlugin.getTempDirectory(), "pagerating.png"));
        }
        catch (Exception exception) {}
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public String[] getLocalizedMetrics() {
        return this.lMetrics;
    }

    public int[] getScores() {
        return this.scores;
    }

    public PageData getPageData() {
        return this.pageData;
    }
}

