/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.internal;

import java.util.ArrayList;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.visualization.blind.ui.internal.PartControlBlind;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Node;

public class SelectionListenerBlind
implements ISelectionListener {
    private PartControlBlind prb;

    public SelectionListenerBlind(PartControlBlind prb) {
        this.prb = prb;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            System.err.println(String.valueOf(this.getClass().getName()) + ":Iselection");
            return;
        }
        IModelService modelService = ModelServiceUtils.getActiveModelService();
        if (modelService != null && modelService instanceof IWebBrowserACTF) {
            ((IWebBrowserACTF)modelService).clearHighlight();
        }
        this.prb.clearHighlight();
        ArrayList<HighlightTargetId> validIdList = new ArrayList<HighlightTargetId>();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Node targetNode = null;
        for (Object target : structuredSelection) {
            if (!(target instanceof IProblemItem)) continue;
            IProblemItem tmpItem = (IProblemItem)target;
            if (!this.prb.getCheckResult().getProblemList().contains(tmpItem)) continue;
            targetNode = tmpItem.getTargetNode();
            if (!tmpItem.isCanHighlight()) continue;
            HighlightTargetId[] ids = tmpItem.getHighlightTargetIds();
            int j = 0;
            while (j < ids.length) {
                validIdList.add(ids[j]);
                ++j;
            }
        }
        HighlightTargetId[] targets = new HighlightTargetId[validIdList.size()];
        validIdList.toArray(targets);
        this.prb.highlight(validIdList);
        if (targets.length == 1 && modelService != null) {
            modelService.jumpToNode(targetNode);
        }
    }
}

