/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.srcviewer;

import org.eclipse.actf.ui.util.IDialogConstants;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.SrcViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogTextSearch {
    private Shell shell;
    private SrcViewer viewer;
    private StyledText styledText;
    private Button searchButton;

    public DialogTextSearch(Shell _shell, SrcViewer _viewer) {
        this.shell = _shell;
        this.shell.setText(Messages.DialogTextSearch_0);
        this.viewer = _viewer;
        this.styledText = this.viewer.getStyledText();
        this.createSettingControls();
    }

    private void createSettingControls() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Composite leftComp = new Composite(composite, 0);
        leftComp.setLayout((Layout)new GridLayout());
        Composite strComp = new Composite(leftComp, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        strComp.setLayout((Layout)gridLayout);
        strComp.setLayoutData((Object)new GridData(768));
        Label label = new Label(strComp, 0);
        label.setText(Messages.DialogTextSearch_1);
        final Text text = new Text(strComp, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (text.getText().equals("")) {
                    DialogTextSearch.this.searchButton.setEnabled(false);
                } else {
                    DialogTextSearch.this.searchButton.setEnabled(true);
                }
            }
        });
        Composite optionComp = new Composite(leftComp, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        optionComp.setLayout((Layout)gridLayout);
        final Button disLetterSize = new Button(optionComp, 32);
        disLetterSize.setText(Messages.DialogTextSearch_3);
        Group group = new Group(optionComp, 0);
        group.setText(Messages.DialogTextSearch_4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        Button upButton = new Button((Composite)group, 16);
        upButton.setText(Messages.DialogTextSearch_5);
        final Button downButton = new Button((Composite)group, 16);
        downButton.setText(Messages.DialogTextSearch_6);
        downButton.setSelection(true);
        Composite rightComp = new Composite(composite, 0);
        rightComp.setLayout((Layout)new GridLayout());
        rightComp.setLayoutData((Object)new GridData(2));
        this.searchButton = new Button(rightComp, 8);
        this.searchButton.setText(Messages.DialogTextSearch_7);
        this.searchButton.setEnabled(false);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.searchButton.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(this.searchButton);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int findedPos;
                String str = text.getText();
                String wholeText = DialogTextSearch.this.styledText.getText();
                if (downButton.getSelection()) {
                    int pos = ((DialogTextSearch)DialogTextSearch.this).styledText.getSelectionRange().x + ((DialogTextSearch)DialogTextSearch.this).styledText.getSelectionRange().y;
                    if (disLetterSize.getSelection()) {
                        findedPos = wholeText.indexOf(str, pos);
                        if (findedPos == -1 && pos > 0) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_8, 288)) {
                                return;
                            }
                            findedPos = wholeText.indexOf(str, 0);
                        }
                    } else {
                        findedPos = wholeText.toLowerCase().indexOf(str.toLowerCase(), pos);
                        if (findedPos == -1 && pos > 0) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_8, 288)) {
                                return;
                            }
                            findedPos = wholeText.toLowerCase().indexOf(str.toLowerCase(), 0);
                        }
                    }
                } else {
                    int pos = ((DialogTextSearch)DialogTextSearch.this).styledText.getSelectionRange().x;
                    if (disLetterSize.getSelection()) {
                        findedPos = wholeText.lastIndexOf(str, pos - 1);
                        if (findedPos == -1 && pos < wholeText.length()) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_10, 288)) {
                                return;
                            }
                            findedPos = wholeText.lastIndexOf(str, wholeText.length());
                        }
                    } else {
                        findedPos = wholeText.toLowerCase().lastIndexOf(str.toLowerCase(), pos - 1);
                        if (findedPos == -1 && pos < wholeText.length()) {
                            if (256 == DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_10, 288)) {
                                return;
                            }
                            findedPos = wholeText.toLowerCase().lastIndexOf(str.toLowerCase(), wholeText.length());
                        }
                    }
                }
                if (findedPos == -1) {
                    DialogTextSearch.this.popupMessage(Messages.DialogTextSearch_12, 32);
                } else {
                    DialogTextSearch.this.viewer.selectByOffset(findedPos, str.length());
                }
            }
        });
        Button cancelButton = new Button(rightComp, 8);
        cancelButton.setText(IDialogConstants.CANCEL);
        gridData = new GridData();
        gridData.widthHint = 100;
        cancelButton.setLayoutData((Object)gridData);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DialogTextSearch.this.shell.close();
            }
        });
    }

    private int popupMessage(String msg, int option) {
        MessageBox msgBox = new MessageBox(this.shell, option);
        msgBox.setMessage(msg);
        return msgBox.open();
    }
}

