/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.actf.visualization.ui.report.table.ResultTableSorterBase;
import org.eclipse.jface.viewers.Viewer;

public class ResultTableSorterLV
extends ResultTableSorterBase {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean inverse = false;
    private int curColumn = 0;
    private int guidelineFinPos = 1 + this.guidelineHolder.getGuidelineData().length;

    private int compareInt(int type1, int type2) {
        return type1 - type2;
    }

    public int compare(Viewer arg0, Object arg1, Object arg2) {
        int result = 0;
        if (arg1 != null && arg2 != null) {
            try {
                IProblemItemImage tmp1 = (IProblemItemImage)arg1;
                IProblemItemImage tmp2 = (IProblemItemImage)arg2;
                if (this.curColumn == 0) {
                    result = this.compareInt(tmp1.getIconId(), tmp2.getIconId());
                } else if (this.curColumn < this.guidelineFinPos) {
                    result = this.compareGuideline((IProblemItem)tmp1, (IProblemItem)tmp2, this.curColumn - 1);
                } else {
                    switch (this.curColumn - this.guidelineFinPos) {
                        case 0: {
                            result = this.compareInt(tmp1.getSeverityLV(), tmp2.getSeverityLV());
                            break;
                        }
                        case 1: {
                            result = this.compareString(tmp1.getForeground(), tmp2.getForeground());
                            break;
                        }
                        case 2: {
                            result = this.compareString(tmp1.getBackground(), tmp2.getBackground());
                            break;
                        }
                        case 3: {
                            result = this.compareInt(tmp1.getX(), tmp2.getX());
                            break;
                        }
                        case 4: {
                            result = this.compareInt(tmp1.getY(), tmp2.getY());
                            break;
                        }
                        case 5: {
                            result = this.compareInt(tmp1.getArea(), tmp2.getArea());
                            break;
                        }
                        case 6: {
                            result = this.compareEvalItem(tmp1.getEvaluationItem(), tmp2.getEvaluationItem());
                            break;
                        }
                        case 7: {
                            result = this.compareString(tmp1.getDescription(), tmp2.getDescription());
                        }
                    }
                }
                if (result == 0) {
                    result = tmp1.getSerialNumber() - tmp2.getSerialNumber();
                }
                if (this.inverse) {
                    return -result;
                }
                return result;
            }
            catch (Exception exception) {}
        }
        return super.compare(arg0, arg1, arg2);
    }

    public void setCurColumn(int curColumn) {
        if (this.curColumn == curColumn) {
            this.inverse = !this.inverse;
        } else {
            this.inverse = false;
            this.curColumn = curColumn;
        }
    }

    public void reset() {
        this.curColumn = -1;
        this.inverse = false;
    }
}

