/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.text.impl;

import java.util.Iterator;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.content.IEditListener;
import org.eclipse.actf.model.dom.odf.content.IEditable;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.range.impl.ITextElementContainerUtil;
import org.eclipse.actf.model.dom.odf.text.AElement;
import org.eclipse.actf.model.dom.odf.text.BookmarkElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AElementImpl
extends ODFElementImpl
implements AElement {
    private static final long serialVersionUID = 884129871818293857L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='h'][parent::*[namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:text:1.0' or local-name()!='list-item'][namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:text:1.0' or local-name()!='list-header']]");

    protected AElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    @Override
    public String getAttrOfficeTitle() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "title")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "title");
        }
        return null;
    }

    @Override
    public String getType() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "type")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "type");
        }
        return null;
    }

    @Override
    public void setType(String typename) {
        this.setAttributeNS("http://www.w3.org/1999/xlink", "type", typename);
    }

    @Override
    public String getHref() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "href");
        }
        return null;
    }

    @Override
    public void setHref(String url) {
        this.setAttributeNS("http://www.w3.org/1999/xlink", "href", url);
    }

    @Override
    public Object getValue() {
        return this.getTextContent();
    }

    @Override
    public void setValue(Object data) {
        if (data instanceof String) {
            this.setTextContent((String)data);
        } else {
            new ODFException("invalid object for text:a setValue function.").printStackTrace();
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public void insert(IEditable data) {
    }

    @Override
    public void addEditListener(IEditListener observer, String topic) {
    }

    @Override
    public void removeEditListener(IEditListener observer, String topic) {
    }

    @Override
    public long getContentSize() {
        return ITextElementContainerUtil.getContentSize(this);
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return ITextElementContainerUtil.getChildIterator(this);
    }

    @Override
    public ODFElement getHrefElement() {
        String type = this.getType();
        if ("simple".equals(type)) {
            String href = this.getHref();
            if (href.startsWith("#") && href.endsWith("|outline")) {
                ODFElement elem;
                String content;
                NodeList nl;
                int indexEndPos;
                String outlineContents = href.substring(1, href.length() - 8);
                int level = 0;
                while ((indexEndPos = outlineContents.indexOf(46)) != -1) {
                    try {
                        String prefixnum = outlineContents.substring(0, indexEndPos);
                        new Integer(prefixnum).intValue();
                        outlineContents = outlineContents.substring(2).trim();
                    }
                    catch (Exception exception) {
                        break;
                    }
                    ++level;
                }
                if (level > 1 && (nl = xpathService.evalPathForNodeList(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='h'][attribute::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='outline-level']='" + level + "']", (Node)this.getOwnerDocument().getDocumentElement())) != null) {
                    int i = 0;
                    while (i < nl.getLength()) {
                        ODFElement elem2 = (ODFElement)nl.item(i);
                        String content2 = elem2.getTextContent();
                        if (content2 != null && outlineContents.equals(content2.trim())) {
                            return elem2;
                        }
                        ++i;
                    }
                }
                NodeList hElemList = xpathService.evalForNodeList(EXP1, (Node)this.getOwnerDocument().getDocumentElement());
                int indexEndPos2 = href.indexOf(46);
                if (indexEndPos2 != -1) {
                    int index = -1;
                    outlineContents = href.substring(indexEndPos2 + 1, href.length() - 8).trim();
                    try {
                        index = new Integer(href.substring(1, indexEndPos2)) - 1;
                    }
                    catch (Exception exception) {}
                    if (index != -1 && hElemList != null && hElemList.getLength() > index && (content = (elem = (ODFElement)hElemList.item(index)).getTextContent()) != null && outlineContents.equals(content.trim())) {
                        return elem;
                    }
                }
                outlineContents = href.substring(1, href.length() - 8);
                int i = 0;
                while (i < hElemList.getLength()) {
                    elem = (ODFElement)hElemList.item(i);
                    content = elem.getTextContent();
                    if (content != null && outlineContents.equals(content.trim())) {
                        return elem;
                    }
                    ++i;
                }
            } else {
                String bookmarkName;
                ODFElement elem;
                if (href.startsWith("#") && href.endsWith("|graphic")) {
                    String drawName = href.substring(1, href.length() - 8);
                    return this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name", drawName);
                }
                if (href.startsWith("#") && href.endsWith("|table")) {
                    String tableName = href.substring(1, href.length() - 6);
                    return this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name", tableName);
                }
                if (href.startsWith("#") && href.endsWith("|frame")) {
                    String frameName = href.substring(1, href.length() - 6);
                    return this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name", frameName);
                }
                if (href.startsWith("#") && href.endsWith("|ole")) {
                    String oleName = href.substring(1, href.length() - 4);
                    return this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name", oleName);
                }
                if (href.startsWith("#") && href.endsWith("|region")) {
                    String regionName = href.substring(1, href.length() - 7);
                    ODFElement elem3 = this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "section", "urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name", regionName);
                    if (elem3 != null) {
                        return elem3;
                    }
                    elem3 = this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "table-of-content", "urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name", regionName);
                    if (elem3 != null) {
                        return elem3;
                    }
                    elem3 = this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "index-title", "urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name", regionName);
                    if (elem3 != null) {
                        return elem3;
                    }
                } else if (href.startsWith("#") && (elem = this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "bookmark", "urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name", bookmarkName = href.substring(1))) instanceof BookmarkElement) {
                    return elem;
                }
            }
        }
        return null;
    }
}

