/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision;

import java.io.File;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.lowvision.util.LowVisionVizResourceUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LowVisionVizPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.actf.visualization.lowvision";
    private static LowVisionVizPlugin plugin;
    private static File tmpDir;

    static {
        tmpDir = null;
    }

    public LowVisionVizPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        String string;
        super.start(bundleContext);
        LowVisionVizPlugin.createTempDirectory();
        if (tmpDir != null && FileUtils.isAvailableDirectory((String)(string = String.valueOf(tmpDir.getAbsolutePath()) + File.separator + "img"))) {
            String string2 = String.valueOf(string) + File.separator;
            LowVisionVizResourceUtil.saveImages(string2);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
        if (tmpDir != null) {
            FileUtils.deleteFiles((File)tmpDir);
        }
    }

    public static LowVisionVizPlugin getDefault() {
        return plugin;
    }

    private static void createTempDirectory() {
        if (tmpDir == null) {
            String string = String.valueOf(plugin.getStateLocation().toOSString()) + File.separator + "tmp";
            tmpDir = FileUtils.isAvailableDirectory((String)string) ? new File(string) : new File(System.getProperty("java.io.tmpdir"));
        }
    }

    public static File createTempFile(String string, String string2) throws Exception {
        LowVisionVizPlugin.createTempDirectory();
        return File.createTempFile(string, string2, tmpDir);
    }

    public static File getTempDirectory() {
        if (tmpDir == null) {
            LowVisionVizPlugin.createTempDirectory();
        }
        return tmpDir;
    }
}

