/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class TTSRegistry {
    private static final String PRIORITY = "priority";
    private static final String TTS_EXTENSION = "org.eclipse.actf.ai.voice.TTSEngine";
    private static final String DEFAULT_TTS = "org.eclipse.actf.ai.tts.sapi.engine.SapiVoice";
    private static IConfigurationElement[] ttsElements;
    private static boolean[] availables;
    private static ITTSEngine[] INSTANCES;

    static {
        TTSRegistry.initialize();
    }

    private static void initialize() {
        ttsElements = Platform.getExtensionRegistry().getConfigurationElementsFor(TTS_EXTENSION);
        Arrays.sort(ttsElements, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement c1, IConfigurationElement c2) {
                String s1 = c1.getAttribute(TTSRegistry.PRIORITY);
                String s2 = c2.getAttribute(TTSRegistry.PRIORITY);
                int i1 = 0;
                int i2 = 0;
                try {
                    i1 = Integer.parseInt(s1);
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    i2 = Integer.parseInt(s2);
                }
                catch (NumberFormatException numberFormatException) {}
                return i2 - i1;
            }
        });
        availables = new boolean[ttsElements.length];
        INSTANCES = new ITTSEngine[ttsElements.length];
        int i = 0;
        while (i < ttsElements.length) {
            try {
                ITTSEngine test = (ITTSEngine)ttsElements[i].createExecutableExtension("class");
                if (test.isAvailable()) {
                    TTSRegistry.availables[i] = true;
                    TTSRegistry.INSTANCES[i] = test;
                }
            }
            catch (Exception exception) {
                TTSRegistry.availables[i] = false;
                TTSRegistry.INSTANCES[i] = null;
            }
            ++i;
        }
    }

    public static boolean isAvailable(String id) {
        try {
            int i = 0;
            while (i < ttsElements.length) {
                if (id.equals(ttsElements[i].getAttribute("id"))) {
                    return availables[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getDefaultEngine() {
        int i = 0;
        while (i < ttsElements.length) {
            if (availables[i]) {
                return ttsElements[i].getAttribute("id");
            }
            ++i;
        }
        return DEFAULT_TTS;
    }

    public static String[][] getLabelAndIds() {
        String[][] labelAndIds = new String[ttsElements.length][2];
        int i = 0;
        while (i < ttsElements.length) {
            labelAndIds[i][0] = ttsElements[i].getAttribute("name");
            labelAndIds[i][1] = availables[i] ? ttsElements[i].getAttribute("id") : "";
            ++i;
        }
        return labelAndIds;
    }

    public static ITTSEngine createTTSEngine(String id) {
        try {
            int i = 0;
            while (i < ttsElements.length) {
                if (id.equals(ttsElements[i].getAttribute("id"))) {
                    if (INSTANCES[i] == null || INSTANCES[i].isDisposed()) {
                        TTSRegistry.INSTANCES[i] = (ITTSEngine)ttsElements[i].createExecutableExtension("class");
                    }
                    return INSTANCES[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

