/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.fields;

import org.eclipse.actf.visualization.gui.msaa.properties.fields.AbstractStringField;

public class IntegerField
extends AbstractStringField {
    private int currValue;
    public int minValue;
    public int maxValue;

    public IntegerField(String labelText, int initValue, int minValue, int maxValue) {
        super(labelText);
        this.currValue = initValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public IntegerField(String labelText, int initValue, int minValue) {
        this(labelText, initValue, minValue, Integer.MAX_VALUE);
    }

    public IntegerField(String labelText, int initValue) {
        this(labelText, initValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int getIntValue() {
        return this.currValue;
    }

    protected String getStringValue() {
        return Integer.toString(this.currValue);
    }

    protected boolean validateControl() {
        String text = this.getText();
        if (text != null) {
            try {
                int value = Integer.parseInt(text);
                return value >= this.minValue && value <= this.maxValue;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean update() {
        if (this.validateControl()) {
            try {
                this.currValue = Integer.parseInt(this.getText());
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

