/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.util.win32.OverlayLabel;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.AccessiblePropertyUtil;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblem;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblemChecker;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblemConst;
import org.eclipse.actf.visualization.gui.preferences.GuiPreferenceManager;
import org.eclipse.actf.visualization.gui.ui.views.AccessibleObjectSelectionProvider;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAProblemsView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MSAAProblemsView
extends ViewPart
implements IMSAAProblemsView,
MSAAProblemConst {
    private static final String[] HEADINGS = new String[]{"", Messages.msaa_description, "Name", "Role", "State", "X", "Y", "W", "H"};
    private static final int[] WEIGHTS = new int[]{1, 15, 8, 6, 10, 2, 2, 2, 2};
    private static final int[] ALIGNMENTS = new int[]{131072, 16384, 16384, 16384, 16384, 131072, 131072, 131072, 131072};
    private TableViewer viewer;
    private MSAAProblemsViewerSorter sorter = new MSAAProblemsViewerSorter();
    private boolean suppressLabelAdjust = false;
    private Action refreshAction;
    private Action showLabelsAction;
    private Action showErrorAction;
    private Action showWarningAction;
    private Action showInformationAction;
    private ProblemFilter filter = new ProblemFilter();

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 68356);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < HEADINGS.length) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(WEIGHTS[i]));
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(HEADINGS[i]);
            tc.setAlignment(ALIGNMENTS[i]);
            tc.setResizable(true);
            final int newSortingColumn = i + 1;
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((MSAAProblemsView)MSAAProblemsView.this).sorter.sortingColumn = newSortingColumn == ((MSAAProblemsView)MSAAProblemsView.this).sorter.sortingColumn ? -newSortingColumn : newSortingColumn;
                    MSAAProblemsView.this.viewer.refresh();
                }
            });
            ++i;
        }
        this.viewer = new TableViewer(table);
        MSAAProblemsContentAndLabelProvider provider = new MSAAProblemsContentAndLabelProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof MSAAProblem) {
                    AccessibleObject object = ((MSAAProblem)selectedElement).getErrorObject();
                    if (object != null) {
                        IMSAAOutlineView outlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW);
                        if (outlineView != null) {
                            outlineView.setSelection(object);
                        } else {
                            HighlightComposite.flashRectangle((Rectangle)object.getAccLocation());
                        }
                    }
                    if (!MSAAProblemsView.this.suppressLabelAdjust) {
                        MSAAProblemsView.this.showOverlayLabels();
                    }
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        HighlightComposite.initOverlayWindow();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refresh() {
        AccessibleObject rootObject = MSAAViewRegistory.getRootObject();
        if (rootObject != null) {
            this.viewer.setInput((Object)new MSAAProblemChecker(rootObject));
            this.showOverlayLabels();
        }
    }

    private void showOverlayLabels() {
        OverlayLabel.removeAll();
        if (this.showLabelsAction.isChecked()) {
            TableItem[] items = this.viewer.getTable().getItems();
            Object currentItem = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            int errorCode = 1;
            while (errorCode <= 3) {
                this.createOverlayLabels(items, currentItem, errorCode);
                ++errorCode;
            }
            OverlayLabel.setOwnerId((String)IGuiViewIDs.ID_REPORTVIEW);
        }
    }

    private void createOverlayLabels(TableItem[] items, Object currentItem, int errorCategory) {
        int i = 0;
        while (i < items.length) {
            AccessibleObject accObject;
            Rectangle location;
            MSAAProblem itemData = (MSAAProblem)items[i].getData();
            if (errorCategory == itemData.getErrorCategory() && (location = (accObject = itemData.getErrorObject()).getAccLocation()) != null) {
                OverlayLabel label = OverlayLabel.create((Object)itemData);
                if (itemData.equals(currentItem)) {
                    label.setForeground(label.getDisplay().getSystemColor(27));
                    label.setBackground(label.getDisplay().getSystemColor(26));
                }
                MSAAProblemsContentAndLabelProvider labelProvider = (MSAAProblemsContentAndLabelProvider)this.viewer.getLabelProvider();
                label.setImage(labelProvider.getColumnImage(itemData, 0));
                String text = String.valueOf(labelProvider.getColumnText(itemData, 1)) + "\n" + MSAAOutlineView.getTreeText(accObject);
                String[][] properties = AccessiblePropertyUtil.getPropertyStrings(accObject);
                label.setTooltop(text, properties);
                label.pack();
                label.setLocation(location.x, location.y);
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        if (e.widget instanceof OverlayLabel) {
                            OverlayLabel[] labels = OverlayLabel.getLabelsAtPosition((Point)e.display.getCursorLocation());
                            if (labels.length > 0) {
                                MSAAProblemsView.this.showSelectionMenu(labels, (OverlayLabel)e.widget);
                            } else {
                                MSAAProblemsView.this.viewer.setSelection((ISelection)new StructuredSelection(((OverlayLabel)e.widget).associatedObject));
                            }
                        }
                    }
                });
                label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent e) {
                        MSAAProblem problem;
                        AccessibleObject object;
                        if (e.widget instanceof OverlayLabel && (object = (problem = (MSAAProblem)((OverlayLabel)e.widget).associatedObject).getErrorObject()) != null) {
                            HighlightComposite.flashRectangle((Rectangle)object.getAccLocation());
                        }
                    }

                    public void mouseExit(MouseEvent e) {
                        HighlightComposite.show((boolean)false);
                    }
                });
            }
            ++i;
        }
    }

    private void showSelectionMenu(OverlayLabel[] labels, OverlayLabel parent) {
        Menu popupMenu = parent.createPopupMenu();
        MenuItem[] menuItems = new MenuItem[labels.length];
        int i = 0;
        while (i < labels.length) {
            menuItems[i] = new MenuItem(popupMenu, 8);
            menuItems[i].setText(labels[i].getMenuText());
            menuItems[i].setImage(labels[i].getImage());
            menuItems[i].setData(labels[i].associatedObject);
            menuItems[i].addArmListener(new ArmListener(){

                public void widgetArmed(ArmEvent e) {
                    AccessibleObject object;
                    Object data = ((MenuItem)e.getSource()).getData();
                    if (data instanceof MSAAProblem && (object = ((MSAAProblem)data).getErrorObject()) != null) {
                        HighlightComposite.flashRectangle((Rectangle)object.getAccLocation());
                    }
                }
            });
            menuItems[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object data = ((MenuItem)e.getSource()).getData();
                    MSAAProblemsView.this.suppressLabelAdjust = true;
                    MSAAProblemsView.this.viewer.setSelection((ISelection)new StructuredSelection(data));
                    MSAAProblemsView.this.suppressLabelAdjust = false;
                }
            });
            ++i;
        }
        popupMenu.setVisible(true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MSAAProblemsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)new AccessibleObjectSelectionProvider(){

            public Object getSelectedAccessibleObject() {
                return MSAAProblemsView.this.getSelectedItem();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showErrorAction);
        manager.add((IAction)this.showWarningAction);
        manager.add((IAction)this.showInformationAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showLabelsAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.showLabelsAction);
    }

    private void makeActions() {
        Shell shell = this.getViewSite().getShell();
        this.refreshAction = new Action(Messages.msaa_refresh){

            public void run() {
                MSAAProblemsView.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.msaa_refresh);
        this.refreshAction.setImageDescriptor(GuiImages.IMAGE_REFRESH);
        this.showLabelsAction = new Action(Messages.msaa_show_problem, 2){

            public void run() {
                MSAAProblemsView.this.showOverlayLabels();
            }
        };
        this.showLabelsAction.setToolTipText(Messages.msaa_show_problem);
        this.showLabelsAction.setImageDescriptor(GuiImages.IMAGE_OVERLAY);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (IGuiViewIDs.ID_REPORTVIEW.equals(OverlayLabel.getOwnerId())) {
                    MSAAProblemsView.this.showOverlayLabels();
                }
            }

            public void shellDeactivated(ShellEvent e) {
                if (IGuiViewIDs.ID_REPORTVIEW.equals(OverlayLabel.getOwnerId())) {
                    OverlayLabel.removeAll((boolean)false);
                }
            }
        });
        this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
        IPreferenceStore store = GuiPreferenceManager.getPreferenceStore();
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("UseOverlayWindow".equals(event.getProperty())) {
                    MSAAProblemsView.this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
                }
            }
        });
        this.showErrorAction = new Action(Messages.msaa_showError, 2){

            public void run() {
                ((MSAAProblemsView)MSAAProblemsView.this).filter.categorySelect[1] = MSAAProblemsView.this.showErrorAction.isChecked();
                MSAAProblemsView.this.refresh();
            }
        };
        this.showErrorAction.setChecked(this.filter.categorySelect[1]);
        this.showWarningAction = new Action(Messages.msaa_showWarning, 2){

            public void run() {
                ((MSAAProblemsView)MSAAProblemsView.this).filter.categorySelect[2] = MSAAProblemsView.this.showWarningAction.isChecked();
                MSAAProblemsView.this.refresh();
            }
        };
        this.showWarningAction.setChecked(this.filter.categorySelect[2]);
        this.showInformationAction = new Action(Messages.msaa_showInformation, 2){

            public void run() {
                ((MSAAProblemsView)MSAAProblemsView.this).filter.categorySelect[3] = MSAAProblemsView.this.showInformationAction.isChecked();
                MSAAProblemsView.this.refresh();
            }
        };
        this.showInformationAction.setChecked(this.filter.categorySelect[3]);
    }

    private Object getSelectedItem() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof MSAAProblem) {
            return ((MSAAProblem)element).getErrorObject();
        }
        return null;
    }

    private class MSAAProblemsContentAndLabelProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    IPropertyChangeListener,
    ITableLabelProvider {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();

        private MSAAProblemsContentAndLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof MSAAProblemChecker) {
                return ((MSAAProblemChecker)inputElement).getProblems();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof MSAAProblem) {
                switch (((MSAAProblem)element).getErrorCategory()) {
                    case 1: {
                        return this.sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                    }
                    case 2: {
                        return this.sharedImages.getImage("IMG_OBJS_WARN_TSK");
                    }
                    case 3: {
                        return this.sharedImages.getImage("IMG_OBJS_INFO_TSK");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MSAAProblem) {
                MSAAProblem problem = (MSAAProblem)element;
                AccessibleObject object = problem.getErrorObject();
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return ((MSAAProblem)element).getErrorDescription();
                    }
                    case 2: {
                        if (object == null) {
                            return "";
                        }
                        return object.getAccName();
                    }
                    case 3: {
                        if (object == null) {
                            return "";
                        }
                        return object.getRoleText();
                    }
                    case 4: {
                        if (object == null) {
                            return "";
                        }
                        return MSAA.getStateText(object.getAccState());
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (object == null) {
                            return "";
                        }
                        Rectangle location = object.getAccLocation();
                        if (location == null) {
                            return "";
                        }
                        switch (columnIndex - 5) {
                            case 0: {
                                return Integer.toString(location.x);
                            }
                            case 1: {
                                return Integer.toString(location.y);
                            }
                            case 2: {
                                return Integer.toString(location.width);
                            }
                            case 3: {
                                return Integer.toString(location.height);
                            }
                        }
                    }
                }
                return "???";
            }
            return null;
        }
    }

    private class MSAAProblemsViewerSorter
    extends ViewerSorter {
        public int sortingColumn = 0;

        private MSAAProblemsViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBaseLabelProvider labelProvider;
            if (this.sortingColumn != 0 && viewer instanceof TableViewer && (labelProvider = ((TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                int columnIndex = Math.abs(this.sortingColumn) - 1;
                String s1 = ((ITableLabelProvider)labelProvider).getColumnText(e1, columnIndex);
                String s2 = ((ITableLabelProvider)labelProvider).getColumnText(e2, columnIndex);
                int result = 0;
                switch (columnIndex) {
                    case 0: {
                        result = ((MSAAProblem)e1).getErrorCategory() - ((MSAAProblem)e2).getErrorCategory();
                        break;
                    }
                    default: {
                        try {
                            result = Integer.parseInt(s1) - Integer.parseInt(s2);
                            break;
                        }
                        catch (Exception exception) {}
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        result = this.getComparator().compare(s1, s2);
                    }
                }
                return this.sortingColumn > 0 ? result : -result;
            }
            return 0;
        }
    }

    private class ProblemFilter
    extends ViewerFilter {
        public boolean[] categorySelect;

        private ProblemFilter() {
            boolean[] blArray = new boolean[5];
            blArray[1] = true;
            this.categorySelect = blArray;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int category;
            if (element instanceof MSAAProblem && (category = ((MSAAProblem)element).getErrorCategory()) < this.categorySelect.length) {
                return this.categorySelect[category];
            }
            return true;
        }
    }
}

