/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.presentation.util;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.engines.lowvision.image.PageImageFactory;
import org.eclipse.actf.visualization.presentation.util.ParamRoom;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class SimulateRoom {
    private static synchronized IPageImage getSimulatedPageImage(IPageImage target, ParamRoom currentSetting) {
        try {
            return PageImageFactory.createSimulationPageImage((IPageImage)target, (LowVisionType)currentSetting.getLowVisionType());
        }
        catch (ImageException imageException) {
            return PageImageFactory.createPageImage();
        }
    }

    public static synchronized ImageData[] doSimulate(IPageImage target, ParamRoom currentSetting, String fileName) {
        ImageData[] imageDataArray = new ImageData[]{};
        try {
            SimulateRoom.getSimulatedPageImage(target, currentSetting).writeToBMPFile(fileName);
            ImageLoader loaderAfterSimulate = new ImageLoader();
            imageDataArray = loaderAfterSimulate.load(fileName);
        }
        catch (LowVisionIOException lvioe) {
            lvioe.printStackTrace();
        }
        return imageDataArray;
    }

    public static synchronized Image doSimulate(IPageImage target, ParamRoom currentSetting, Display display, String fileS) {
        Image image = null;
        try {
            IPageImage simulatedPageImage = PageImageFactory.createSimulationPageImage((IPageImage)target, (LowVisionType)currentSetting.getLowVisionType());
            simulatedPageImage.writeToBMPFile(fileS);
            image = new Image((Device)display, fileS);
        }
        catch (ImageException ie) {
            ie.printStackTrace();
        }
        catch (LowVisionIOException lvioe) {
            lvioe.printStackTrace();
        }
        return image;
    }
}

