/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;

public class EdgeDetector {
    public static final short METHOD_LAPLACIAN4_MINUS = 0;
    public static final short METHOD_LAPLACIAN4_PLUS = 1;
    public static final short METHOD_LAPLACIAN8_MINUS = 2;
    public static final short METHOD_LAPLACIAN8_PLUS = 3;
    public static final short METHOD_DEFAULT = 0;
    private static final float[] LAPLACIAN4_3X3_MINUS = new float[]{0.0f, 1.0f, 0.0f, 1.0f, -4.0f, 1.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] LAPLACIAN4_3X3_PLUS = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    private static final float[] LAPLACIAN8_3X3_MINUS = new float[]{1.0f, 1.0f, 1.0f, 1.0f, -8.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] LAPLACIAN8_3X3_PLUS = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    private BufferedImage srcBufferedImage = null;
    private BufferedImage destBufferedImage = null;

    public EdgeDetector(BufferedImage _src) throws LowVisionException {
        this(_src, 0);
    }

    public EdgeDetector(BufferedImage _src, short _method) throws LowVisionException {
        this.srcBufferedImage = _src;
        if (_method == 0) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN4_3X3_MINUS);
        } else if (_method == 1) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN4_3X3_PLUS);
        } else if (_method == 2) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN8_3X3_MINUS);
        } else if (_method == 3) {
            this.destBufferedImage = this.convolve(this.srcBufferedImage, 3, 3, LAPLACIAN8_3X3_PLUS);
        } else {
            throw new LowVisionException("Unknown method: " + _method);
        }
    }

    private BufferedImage convolve(BufferedImage _srcImage, int _kernelWidth, int _kernelHeight, float[] _kernelData) {
        BufferedImage tmpImage = new BufferedImage(_srcImage.getWidth(), _srcImage.getHeight(), 1);
        Kernel ker = new Kernel(_kernelWidth, _kernelHeight, _kernelData);
        ConvolveOp cop = new ConvolveOp(ker, 1, null);
        return cop.filter(_srcImage, tmpImage);
    }

    public BufferedImage writeToImage() {
        return this.destBufferedImage;
    }
}

