/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;

public class ColorYIQ {
    private float Y;
    private float I;
    private float Q;

    public ColorYIQ(ColorSRGB _srgb) throws ColorException {
        this(_srgb, false);
    }

    public ColorYIQ(ColorSRGB _srgb, boolean _check) throws ColorException {
        float r = _srgb.getR();
        float g = _srgb.getG();
        float b = _srgb.getB();
        this.Y = 0.299f * r + 0.587f * g + 0.114f * b;
        this.I = 0.596f * r - 0.274f * g - 0.322f * b;
        this.Q = 0.211f * r - 0.522f * g + 0.311f * b;
        if (_check) {
            this.rangeCheck();
        } else {
            this.rangeAdjust();
        }
    }

    private void rangeCheck() throws ColorException {
        if (this.Y < 0.0f || 1.0f < this.Y) {
            throw new ColorException("Y is out of range: " + this.Y);
        }
        if (this.I < 0.0f || 1.0f < this.I) {
            throw new ColorException("I is out of range: " + this.I);
        }
        if (this.Q < 0.0f || 1.0f < this.Q) {
            throw new ColorException("Q is out of range: " + this.Q);
        }
    }

    private void rangeAdjust() {
        if (this.Y < 0.0f) {
            this.Y = 0.0f;
        } else if (this.Y > 1.0f) {
            this.Y = 1.0f;
        }
        if (this.I < 0.0f) {
            this.I = 0.0f;
        } else if (this.I > 1.0f) {
            this.I = 1.0f;
        }
        if (this.Q < 0.0f) {
            this.Q = 0.0f;
        } else if (this.Q > 1.0f) {
            this.Q = 1.0f;
        }
    }

    public float getY() {
        return this.Y;
    }

    public float getI() {
        return this.I;
    }

    public float getQ() {
        return this.Q;
    }

    public void setY(float _y) {
        this.Y = _y;
    }

    public void seti(float _i) {
        this.I = _i;
    }

    public void setQ(float _q) {
        this.Q = _q;
    }

    public ColorSRGB toSRGB() throws ColorException {
        float r = 1.0f * this.Y + 0.955653f * this.I + 0.622895f * this.Q;
        float g = 1.0f * this.Y - 0.27215f * this.I - 0.64834f * this.Q;
        float b = 1.0f * this.Y - 1.10516f * this.I + 1.704625f * this.Q;
        return new ColorSRGB(r, g, b, false);
    }
}

