/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogramBin;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;

public class ColorHistogram {
    private HashMap<Integer, ColorHistogramBin> pixelMap = new HashMap();
    private ColorHistogramBin[] sortedArrayByOccurrence = null;
    private boolean changedFlag = true;

    public boolean changed() {
        return this.changedFlag;
    }

    public ColorHistogramBin[] getSortedArrayByOccurrence() {
        return this.sortedArrayByOccurrence;
    }

    public int getSize() {
        return this.pixelMap.size();
    }

    public void put(int _color) {
        this.changedFlag = true;
        Integer curPixel = new Integer(_color);
        ColorHistogramBin curHistBin = this.pixelMap.get(curPixel);
        if (curHistBin != null) {
            ++curHistBin.occurrence;
        } else {
            curHistBin = new ColorHistogramBin(curPixel);
            ++curHistBin.occurrence;
            this.pixelMap.put(curPixel, curHistBin);
        }
    }

    public void makeSortedArrayByOccurrence() {
        if (!this.changedFlag) {
            return;
        }
        if (this.getSize() == 0) {
            return;
        }
        this.changedFlag = false;
        Object[] keyArray = this.pixelMap.keySet().toArray();
        int len = keyArray.length;
        this.sortedArrayByOccurrence = new ColorHistogramBin[len];
        int i = 0;
        while (i < len) {
            this.sortedArrayByOccurrence[i] = this.pixelMap.get(keyArray[i]);
            ++i;
        }
        Arrays.sort(this.sortedArrayByOccurrence, new ComparatorByOccurrence());
    }

    public static ColorHistogram makeColorHistogram(int[][] _pixel, int _width, int _height) {
        ColorHistogram histo = new ColorHistogram();
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                histo.put(_pixel[j][i]);
                ++i;
            }
            ++j;
        }
        histo.makeSortedArrayByOccurrence();
        return histo;
    }

    public static ColorHistogram makeColorHistogram(IInt2D _i2d) {
        return ColorHistogram.makeColorHistogram(_i2d.getData(), _i2d.getWidth(), _i2d.getHeight());
    }

    public void dump(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw);
    }

    public void dump(PrintWriter _pw) {
        if (this.changedFlag) {
            this.makeSortedArrayByOccurrence();
        }
        int len = this.sortedArrayByOccurrence.length;
        int i = 0;
        while (i < len) {
            ColorHistogramBin cur = this.sortedArrayByOccurrence[i];
            int curOccur = cur.occurrence;
            int r = cur.getR();
            int g = cur.getG();
            int b = cur.getB();
            _pw.println(String.valueOf(i) + ": rgb = ( " + r + ", " + g + ", " + b + ") occurrence = " + curOccur);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ComparatorByOccurrence
    implements Comparator<ColorHistogramBin> {
        @Override
        public int compare(ColorHistogramBin o1, ColorHistogramBin o2) {
            return o2.occurrence - o1.occurrence;
        }
    }
}

