/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteriorImageComponent {
    InteriorImage containerImage = null;
    int color;
    int numConnectedComponents = 0;
    ConnectedComponent[] connectedComponents = null;
    int count = 0;
    double occupation = 0.0;

    InteriorImageComponent(InteriorImage _ii, int _color, Vector<ConnectedComponent> _vec) {
        this.containerImage = _ii;
        this.color = _color;
        this.numConnectedComponents = _vec.size();
        if (this.numConnectedComponents > 0) {
            this.connectedComponents = new ConnectedComponent[this.numConnectedComponents];
            int k = 0;
            while (k < this.numConnectedComponents) {
                ConnectedComponent cc = _vec.elementAt(k);
                this.count += cc.getCount();
                this.connectedComponents[k] = cc;
                ++k;
            }
            this.occupation = (double)this.count / (double)(_ii.getWidth() * _ii.getHeight());
        }
    }

    public InteriorImage getContainerImage() {
        return this.containerImage;
    }

    public int getColor() {
        return this.color;
    }

    public int getNumConnectedComponents() {
        return this.numConnectedComponents;
    }

    public ConnectedComponent[] getConnectedComponents() {
        return this.connectedComponents;
    }

    public ConnectedComponent getConnectedComponent(int _index) throws ImageException {
        if (_index < 0 || this.numConnectedComponents <= _index) {
            throw new ImageException("Out of range: specified index = " + _index + ", while #ConnectedComponent = " + this.numConnectedComponents);
        }
        return this.connectedComponents[_index];
    }

    public int getCount() {
        return this.count;
    }

    public double getOccupation() {
        return this.occupation;
    }
}

