/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;

public class LabeledImage {
    public static final short METHOD_8_CONNECTIVITY = 0;
    public static final short METHOD_4_CONNECTIVITY = 1;
    int width;
    int height;
    int[][] label;
    int numComponents;
    ConnectedComponent[] components;
    short method;
    int left;
    int right;
    int top;
    int bottom;
    int count;

    public LabeledImage(BinaryImage _bi) {
        this(_bi, 0);
    }

    public LabeledImage(BinaryImage _bi, short _method) {
        int i;
        this.width = _bi.width;
        this.height = _bi.height;
        this.label = new int[this.height][this.width];
        this.method = _method;
        Vector<ConnectedComponent> ccVector = new Vector<ConnectedComponent>();
        int currentLabel = 1;
        int j = 0;
        while (j < this.height) {
            i = 0;
            while (i < this.width) {
                if (_bi.data[j][i] > 0 && this.label[j][i] == 0) {
                    this.label[j][i] = currentLabel;
                    this.count = 1;
                    this.labelNeighbor(_bi, i, j, currentLabel, _method);
                    ConnectedComponent currentCC = new ConnectedComponent(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1, this.count);
                    int j2 = this.top;
                    while (j2 <= this.bottom) {
                        int i2 = this.left;
                        while (i2 <= this.right) {
                            if (this.label[j2][i2] == currentLabel) {
                                currentCC.shape.data[j2 - this.top][i2 - this.left] = 1;
                            }
                            ++i2;
                        }
                        ++j2;
                    }
                    ccVector.addElement(currentCC);
                    ++currentLabel;
                }
                ++i;
            }
            ++j;
        }
        this.numComponents = currentLabel - 1;
        this.components = new ConnectedComponent[this.numComponents];
        int conn = 0;
        if (this.method == 0) {
            conn = 2;
        } else if (this.method == 1) {
            conn = 1;
        }
        i = 0;
        while (i < this.numComponents) {
            this.components[i] = (ConnectedComponent)ccVector.elementAt(i);
            this.components[i].connectivity = (short)conn;
            ++i;
        }
    }

    private void labelNeighbor(BinaryImage _bi, int _i, int _j, int _label, short _method) {
        this.left = _i;
        this.right = _i;
        this.top = _j;
        this.bottom = _j;
        Stack<Coord> labelingStack = new Stack<Coord>();
        Coord startCoord = new Coord(_i, _j);
        labelingStack.push(startCoord);
        while (!labelingStack.empty()) {
            Coord co2;
            Coord co = (Coord)labelingStack.pop();
            int i = co.x;
            int j = co.y;
            if (i < this.width - 1 && _bi.data[j][i + 1] > 0 && this.label[j][i + 1] == 0) {
                this.label[j][i + 1] = _label;
                ++this.count;
                if (this.right < i + 1) {
                    this.right = i + 1;
                }
                co2 = new Coord(i + 1, j);
                labelingStack.push(co2);
            }
            if (i > 0 && _bi.data[j][i - 1] > 0 && this.label[j][i - 1] == 0) {
                this.label[j][i - 1] = _label;
                ++this.count;
                if (this.left > i - 1) {
                    this.left = i - 1;
                }
                co2 = new Coord(i - 1, j);
                labelingStack.push(co2);
            }
            if (j > 0 && _bi.data[j - 1][i] > 0 && this.label[j - 1][i] == 0) {
                this.label[j - 1][i] = _label;
                ++this.count;
                if (this.top > j - 1) {
                    this.top = j - 1;
                }
                co2 = new Coord(i, j - 1);
                labelingStack.push(co2);
            }
            if (j < this.height - 1 && _bi.data[j + 1][i] > 0 && this.label[j + 1][i] == 0) {
                this.label[j + 1][i] = _label;
                ++this.count;
                if (this.bottom < j + 1) {
                    this.bottom = j + 1;
                }
                co2 = new Coord(i, j + 1);
                labelingStack.push(co2);
            }
            if (_method != 0) continue;
            if (j > 0 && i > 0 && _bi.data[j - 1][i - 1] > 0 && this.label[j - 1][i - 1] == 0) {
                this.label[j - 1][i - 1] = _label;
                ++this.count;
                if (this.left > i - 1) {
                    this.left = i - 1;
                }
                if (this.top > j - 1) {
                    this.top = j - 1;
                }
                co2 = new Coord(i - 1, j - 1);
                labelingStack.push(co2);
            }
            if (j > 0 && i < this.width - 1 && _bi.data[j - 1][i + 1] > 0 && this.label[j - 1][i + 1] == 0) {
                this.label[j - 1][i + 1] = _label;
                ++this.count;
                if (this.right < i + 1) {
                    this.right = i + 1;
                }
                if (this.top > j - 1) {
                    this.top = j - 1;
                }
                co2 = new Coord(i + 1, j - 1);
                labelingStack.push(co2);
            }
            if (j < this.height - 1 && i > 0 && _bi.data[j + 1][i - 1] > 0 && this.label[j + 1][i - 1] == 0) {
                this.label[j + 1][i - 1] = _label;
                ++this.count;
                if (this.left > i - 1) {
                    this.left = i - 1;
                }
                if (this.bottom < j + 1) {
                    this.bottom = j + 1;
                }
                co2 = new Coord(i - 1, j + 1);
                labelingStack.push(co2);
            }
            if (j >= this.height - 1 || i >= this.width - 1 || _bi.data[j + 1][i + 1] <= 0 || this.label[j + 1][i + 1] != 0) continue;
            this.label[j + 1][i + 1] = _label;
            ++this.count;
            if (this.right < i + 1) {
                this.right = i + 1;
            }
            if (this.bottom < j + 1) {
                this.bottom = j + 1;
            }
            co2 = new Coord(i + 1, j + 1);
            labelingStack.push(co2);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[][] getLabel() {
        return this.label;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public ConnectedComponent[] getComponents() {
        return this.components;
    }

    public short getMethod() {
        return this.method;
    }

    public BinaryImage toBinaryImage() {
        BinaryImage bi = new BinaryImage(this.width, this.height);
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (this.label[j][i] != 0) {
                    bi.data[j][i] = 1;
                }
                ++i;
            }
            ++j;
        }
        return bi;
    }

    public BufferedImage toBufferedImage() throws ImageException {
        if (this.numComponents >> 24 != 0) {
            throw new ImageException("Too many labels to make bufferedImage.");
        }
        BufferedImage destImage = new BufferedImage(this.width, this.height, 1);
        WritableRaster destRaster = destImage.copyData(null);
        DataBufferInt destBufInt = (DataBufferInt)destRaster.getDataBuffer();
        int[] destArray = destBufInt.getData();
        int k = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                destArray[k] = ColorUtil.distinguishableColor(this.label[j][i]);
                ++k;
                ++i;
            }
            ++j;
        }
        destImage.setData(destRaster);
        return destImage;
    }

    public void dump(PrintStream _ps, boolean _printLabel) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw, _printLabel);
    }

    public void dump(PrintWriter _pw, boolean _printLabel) {
        if (_printLabel) {
            this.dumpLabel(_pw);
        } else {
            this.dumpComponents(_pw);
        }
    }

    public void dumpLabel(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dumpLabel(pw);
    }

    public void dumpLabel(PrintWriter _pw) {
        _pw.println("-------------------------------");
        _pw.println("Dumping a labeledImage");
        _pw.println("Width = " + this.width + ", Height = " + this.height);
        int j = 0;
        while (j < this.height) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.width) {
                if (this.label[j][i] == 0) {
                    sb.append(".");
                } else {
                    sb.append("" + this.label[j][i] % 10);
                }
                ++i;
            }
            _pw.println(sb.toString());
            ++j;
        }
        _pw.println("-------------------------------");
    }

    public void dumpComponents(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dumpComponents(pw);
    }

    public void dumpComponents(PrintWriter _pw) {
        _pw.println("-------------------------------");
        _pw.println("Dumping components");
        _pw.println("# of components = " + this.numComponents);
        int i = 0;
        while (i < this.numComponents) {
            this.dumpComponents(_pw, i);
            ++i;
        }
        _pw.println("-------------------------------");
    }

    public void dumpComponents(PrintStream _ps, int _i) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dumpComponents(pw, _i);
    }

    public void dumpComponents(PrintWriter _pw, int _i) {
        _pw.println("-----");
        _pw.println("Components # = " + _i);
        this.components[_i].dump(_pw);
    }
}

