/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class FieldOp
implements ILowVisionOperator {
    public static final short TYPE_CIRCLE_INT = 1;
    public static final short TYPE_CIRCLE_FLOAT = 2;
    public static final float CIRCLE_WIDTH = 20.0f;
    BufferedImage filterImage;
    short type = 0;
    int diameterInt;
    float diameterFloat;

    public FieldOp(short _type) {
        this.type = _type;
    }

    public FieldOp(short _type, int _param1) throws LowVisionException {
        this(_type);
        if (this.type != 1) {
            throw new LowVisionException("The type is unknown, or the type and the parameter(s) do not match: type = " + _type + ", param = " + _param1);
        }
        this.diameterInt = _param1;
    }

    public FieldOp(short _type, float _param1) throws LowVisionException {
        this(_type);
        if (this.type != 2) {
            throw new LowVisionException("The type is unknown, or the type and the parameter(s) do not match: type = " + _type + ", param = " + _param1);
        }
        this.diameterFloat = _param1;
    }

    public BufferedImage filter(BufferedImage _src, BufferedImage _dest) throws LowVisionException {
        int width = _src.getWidth();
        int height = _src.getHeight();
        this.createFilterImage(this.type, width, height);
        BufferedImage destImage = _dest;
        if (_dest == null) {
            destImage = new BufferedImage(width, height, 1);
        }
        Graphics2D g2d = destImage.createGraphics();
        g2d.drawImage(_src, null, 0, 0);
        AlphaComposite ac = AlphaComposite.getInstance(3);
        g2d.setComposite(ac);
        g2d.drawImage(this.filterImage, null, 0, 0);
        return destImage;
    }

    private void createFilterImage(short _type, int _width, int _height) throws LowVisionException {
        this.filterImage = new BufferedImage(_width, _height, 2);
        WritableRaster filterRaster = this.filterImage.copyData(null);
        DataBufferInt filterBufInt = (DataBufferInt)filterRaster.getDataBuffer();
        int[] filterArray = filterBufInt.getData();
        int[][] alphaField = null;
        if (_type == 1) {
            alphaField = this.getCircleAlphaField(_width, _height, (float)this.diameterInt / (float)_width);
        } else if (_type == 2) {
            alphaField = this.getCircleAlphaField(_width, _height, this.diameterFloat);
        } else {
            throw new LowVisionException("Unknown field type: " + _type);
        }
        int k = 0;
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                filterArray[k] = alphaField[j][i] << 24 & 0xFF000000;
                ++k;
                ++i;
            }
            ++j;
        }
        this.filterImage.setData(filterRaster);
    }

    private int[][] getCircleAlphaField(int _width, int _height, float _diameter) {
        int[][] field = new int[_height][_width];
        float r = (float)_width * _diameter / 2.0f;
        float r2 = 0.0f;
        if (r > 20.0f) {
            r2 = r - 20.0f;
        }
        float xc = (float)_width / 2.0f;
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                float x0 = (float)i - xc;
                float y0 = (float)j - xc;
                float r0 = (float)Math.sqrt(x0 * x0 + y0 * y0);
                int a = Math.round((r0 - r2) / (r - r2) * 255.0f);
                if (a < 0) {
                    a = 0;
                } else if (a > 255) {
                    a = 255;
                }
                field[j][i] = a;
                ++i;
            }
            ++j;
        }
        return field;
    }
}

