/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHFormCtrlElement;
import org.eclipse.actf.model.internal.dom.html.impl.SHOptionElement;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

public class SHSelectElement
extends SHFormCtrlElement
implements HTMLSelectElement {
    private static final long serialVersionUID = 7615986491286782573L;

    protected SHSelectElement(String name, SHDocument doc) {
        super(name, doc);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public int getSelectedIndex() {
        NodeList options = this.getElementsByTagName("OPTION");
        int i = 0;
        while (i < options.getLength()) {
            if (((SHOptionElement)options.item(i)).getSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSelectedIndex(int selectedIndex) {
        NodeList options = this.getElementsByTagName("OPTION");
        if (selectedIndex < 0 || options.getLength() <= selectedIndex) {
            return;
        }
        ((SHOptionElement)options.item(selectedIndex)).setAttribute("selected", "selected");
    }

    public String getValue() {
        NodeList options = this.getElementsByTagName("OPTION");
        int i = 0;
        while (i < options.getLength()) {
            SHOptionElement opt = (SHOptionElement)options.item(i);
            if (opt.getSelected()) {
                return opt.getValue();
            }
            ++i;
        }
        return null;
    }

    public void setValue(String value) {
        NodeList options = this.getElementsByTagName("OPTION");
        int i = 0;
        while (i < options.getLength()) {
            SHOptionElement opt = (SHOptionElement)options.item(i);
            if (opt.getValue().equals(value)) {
                opt.setAttribute("selected", "selected");
            }
            ++i;
        }
    }

    public int getLength() {
        return this.getElementsByTagName("OPTION").getLength();
    }

    public HTMLCollection getOptions() {
        NodeList options = this.getElementsByTagName("OPTION");
        return ((SHDocument)this.getOwnerDocument()).createCollection(options);
    }

    public boolean getMultiple() {
        String mul = this.getAttribute("multiple");
        return mul != null && mul.length() != 0;
    }

    public void setMultiple(boolean multiple) {
        this.setAttribute("multiple", multiple ? "multiple" : null);
    }

    public int getSize() {
        String size = this.getAttribute("size");
        if (size != null && size.length() > 0) {
            return Integer.parseInt(size);
        }
        return -1;
    }

    public void setSize(int size) {
        this.setAttribute("size", Integer.toString(size));
    }

    public void add(HTMLElement element, HTMLElement before) {
        if (before == null) {
            this.insertBefore(element, this.getFirstChild());
        } else {
            this.insertBefore(element, before);
        }
    }

    public void remove(int index) {
        NodeList options = this.getElementsByTagName("OPTION");
        if (index < 0 || options.getLength() <= index) {
            return;
        }
        HTMLOptionElement opt = (HTMLOptionElement)options.item(index);
        opt.getParentNode().removeChild(opt);
    }

    public void blur() {
    }

    public void focus() {
    }
}

