/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizeMapUtil {
    public static void createNode2NodeMap(Document orig, Document dest, VisualizeMapDataImpl mapData) {
        NodeList bodyNl = dest.getElementsByTagName("body");
        NodeList origBodyNl = orig.getElementsByTagName("body");
        if (origBodyNl.getLength() > 0) {
            Element bodyEl = (Element)bodyNl.item(0);
            Element origBodyEl = (Element)origBodyNl.item(0);
            if (origBodyEl.hasChildNodes()) {
                Stack<Node> stack = new Stack<Node>();
                Stack<Node> origStack = new Stack<Node>();
                stack.push(bodyEl);
                origStack.push(origBodyEl);
                Node curNode = bodyEl.getFirstChild();
                Node origCurNode = origBodyEl.getFirstChild();
                while (origCurNode != null && origStack.size() > 0) {
                    mapData.addOrigResultMapping(origCurNode, curNode);
                    try {
                        if (origCurNode.hasChildNodes()) {
                            stack.push(curNode);
                            origStack.push(origCurNode);
                            curNode = curNode.getFirstChild();
                            origCurNode = origCurNode.getFirstChild();
                            continue;
                        }
                        if (origCurNode.getNextSibling() != null) {
                            curNode = curNode.getNextSibling();
                            origCurNode = origCurNode.getNextSibling();
                            continue;
                        }
                        origCurNode = null;
                        while (origCurNode == null && origStack.size() > 0) {
                            curNode = (Node)stack.pop();
                            origCurNode = (Node)origStack.pop();
                            curNode = curNode.getNextSibling();
                            origCurNode = origCurNode.getNextSibling();
                        }
                    }
                    catch (NullPointerException npe) {
                        npe.printStackTrace();
                        break;
                    }
                }
            }
        }
    }

    public static Map<String, String> createMapTextMap(Document doc) {
        HashMap<String, String> mapTextMap = new HashMap<String, String>();
        NodeList nl = doc.getElementsByTagName("area");
        int size = nl.getLength();
        int i = 0;
        while (i < size) {
            Node node = nl.item(i);
            if (node.getParentNode().getNodeName().equals("map")) {
                String curText = ((Element)node).getAttribute("alt");
                String mapName = ((Element)node.getParentNode()).getAttribute("name");
                String mapText = (String)mapTextMap.get(mapName.toLowerCase());
                if (mapText != null) {
                    mapTextMap.put(mapName.toLowerCase(), String.valueOf(mapText) + ". " + curText);
                } else {
                    mapTextMap.put(mapName.toLowerCase(), curText);
                }
            }
            ++i;
        }
        return mapTextMap;
    }
}

