/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.presentation.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RoomPlugin
extends AbstractUIPlugin {
    public static String PLUGIN_ID = "org.eclipse.actf.visualization.presentation";
    private static RoomPlugin _plugin;
    private static BundleContext _context;
    private static File tmpDir;

    public RoomPlugin() {
        _plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        String string;
        super.start(bundleContext);
        _context = bundleContext;
        RoomPlugin.createTempDirectory();
        if (tmpDir != null && FileUtils.isAvailableDirectory((String)(string = String.valueOf(tmpDir.getAbsolutePath()) + File.separator + "html"))) {
            String string2 = String.valueOf(string) + File.separator + "en";
            String string3 = String.valueOf(string) + File.separator + "ja";
            String string4 = String.valueOf(string) + File.separator + "images";
            Bundle bundle = this.getBundle();
            if (FileUtils.isAvailableDirectory((String)string2) && FileUtils.isAvailableDirectory((String)string3) && FileUtils.isAvailableDirectory((String)string4)) {
                string2 = String.valueOf(string2) + File.separator;
                string3 = String.valueOf(string3) + File.separator;
                string4 = String.valueOf(string4) + File.separator;
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/en/large.html"), (String)(String.valueOf(string2) + "large.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/en/middle.html"), (String)(String.valueOf(string2) + "middle.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/en/small.html"), (String)(String.valueOf(string2) + "small.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/ja/large.html"), (String)(String.valueOf(string3) + "large.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/ja/middle.html"), (String)(String.valueOf(string3) + "middle.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/ja/small.html"), (String)(String.valueOf(string3) + "small.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/images/auditorium.png"), (String)(String.valueOf(string4) + "auditorium.png"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/images/largeMeetingRoom.png"), (String)(String.valueOf(string4) + "largeMeetingRoom.png"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/images/smallMeetingRoom.png"), (String)(String.valueOf(string4) + "smallMeetingRoom.png"), (boolean)true);
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        this.deleteFiles(tmpDir);
        _plugin = null;
        _context = null;
    }

    public static RoomPlugin getDefault() {
        return _plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    public static String getDirectory(String string) {
        try {
            URL uRL = _context.getBundle().getEntry(string);
            uRL = FileLocator.resolve((URL)uRL);
            return new Path(uRL.getPath()).makeAbsolute().toOSString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static String getTempDirectory() {
        if (tmpDir != null) {
            return String.valueOf(tmpDir.getAbsolutePath()) + File.separator;
        }
        return "";
    }

    private static void createTempDirectory() {
        String string;
        if (tmpDir == null && FileUtils.isAvailableDirectory((String)(string = String.valueOf(_plugin.getStateLocation().toOSString()) + File.separator + "tmp"))) {
            tmpDir = new File(string);
        }
    }

    public static File createTempFile(String string, String string2) throws Exception {
        RoomPlugin.createTempDirectory();
        return File.createTempFile(string, string2, tmpDir);
    }

    private void deleteFiles(File file) {
        if (file != null) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.deleteFiles(fileArray[n]);
                }
                fileArray[n].delete();
                ++n;
            }
        }
    }
}

