/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner;

import org.eclipse.actf.examples.adesigner.ADesignerPlugin;
import org.eclipse.actf.model.ui.editor.actions.FavoritesMenu;
import org.eclipse.actf.ui.util.ProgressContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private FavoritesMenu _favoritesMenu;
    private ActionFactory.IWorkbenchAction _maximizeAction;
    private ActionFactory.IWorkbenchAction _nextViewAction;
    private ActionFactory.IWorkbenchAction _prevViewAction;
    private ActionFactory.IWorkbenchAction _nextEditorAction;
    private ActionFactory.IWorkbenchAction _prevEditorAction;
    private ActionFactory.IWorkbenchAction _showViewMenuAction;
    private ActionFactory.IWorkbenchAction _preferenceAction;
    private ActionFactory.IWorkbenchAction _helpAction;
    private ActionFactory.IWorkbenchAction _aboutAction;
    private ActionFactory.IWorkbenchAction _quitAction;
    private ActionFactory.IWorkbenchAction _closeAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this._favoritesMenu = new FavoritesMenu(window);
        this._maximizeAction = ActionFactory.MAXIMIZE.create(window);
        this._nextViewAction = ActionFactory.NEXT_PART.create(window);
        this._prevViewAction = ActionFactory.PREVIOUS_PART.create(window);
        this._nextEditorAction = ActionFactory.NEXT_EDITOR.create(window);
        this._prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(window);
        this._showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(window);
        this._preferenceAction = ActionFactory.PREFERENCES.create(window);
        this._helpAction = ActionFactory.HELP_CONTENTS.create(window);
        this._aboutAction = ActionFactory.ABOUT.create(window);
        this._quitAction = ActionFactory.QUIT.create(window);
        this._closeAction = ActionFactory.CLOSE.create(window);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(ADesignerPlugin.getResourceString("adesigner.menu.file"), "file");
        fileMenu.add((IContributionItem)new Separator("fileGroup"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new Separator("closeGroup"));
        fileMenu.add((IAction)this._closeAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new Separator("modeGroup"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new Separator("cacheGroup"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new Separator("exitGroup"));
        fileMenu.add((IAction)this._quitAction);
        menuBar.add((IContributionItem)fileMenu);
        MenuManager toolMenu = new MenuManager(ADesignerPlugin.getResourceString("adesigner.menu.viz"), "visualization");
        menuBar.add((IContributionItem)toolMenu);
        menuBar.add((IContributionItem)this._favoritesMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        MenuManager windowMenu = new MenuManager(ADesignerPlugin.getResourceString("adesigner.menu.window"), "window");
        windowMenu.add((IContributionItem)new Separator());
        MenuManager navigationMenu = new MenuManager(ADesignerPlugin.getResourceString("adesigner.menu.navigation"), "navigationMenu");
        windowMenu.add((IContributionItem)navigationMenu);
        navigationMenu.add((IAction)this._showViewMenuAction);
        navigationMenu.add((IContributionItem)new Separator());
        navigationMenu.add((IAction)this._maximizeAction);
        navigationMenu.add((IAction)this._nextEditorAction);
        navigationMenu.add((IAction)this._prevEditorAction);
        navigationMenu.add((IContributionItem)new Separator());
        navigationMenu.add((IAction)this._nextViewAction);
        navigationMenu.add((IAction)this._prevViewAction);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this._preferenceAction);
        menuBar.add((IContributionItem)windowMenu);
        MenuManager helpMenu = new MenuManager(ADesignerPlugin.getResourceString("adesigner.menu.help"), "help");
        helpMenu.add((IContributionItem)new Separator("helpStart"));
        helpMenu.add((IAction)this._helpAction);
        helpMenu.add((IContributionItem)new Separator("helpEnd"));
        helpMenu.add((IAction)this._aboutAction);
        menuBar.add((IContributionItem)helpMenu);
        this.register((IAction)this._maximizeAction);
        this.register((IAction)this._nextEditorAction);
        this.register((IAction)this._prevEditorAction);
        this.register((IAction)this._nextViewAction);
        this.register((IAction)this._prevViewAction);
        this.register((IAction)this._showViewMenuAction);
        this.register((IAction)this._preferenceAction);
        this.register((IAction)this._helpAction);
        this.register((IAction)this._aboutAction);
        this.register((IAction)this._quitAction);
        this.register((IAction)this._closeAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this._nextEditorAction, (ActionFactory.IWorkbenchAction)this._prevEditorAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this._nextViewAction, (ActionFactory.IWorkbenchAction)this._prevViewAction);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        super.fillStatusLine(statusLine);
        ProgressContribution pc = new ProgressContribution("actf.progress");
        pc.setVisible(false);
        statusLine.add((IContributionItem)pc);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        super.fillCoolBar(coolBar);
        coolBar.add((IContributionItem)new GroupMarker("additions"));
    }
}

