/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.internal.flash.Messages;

public class FlashStatusUtil {
    private static final String STATUS_OK = Messages.flash_player_ok;
    private static final String STATUS_NG = Messages.flash_player_embed;
    private static final String STATUS_NA = Messages.flash_player_no_xcode;
    private static final String STATUS_WAIT = Messages.flash_player_loading;
    private static final String STATUS_HTTPS = Messages.flash_player_https;
    private static final String OBJECT = "OBJECT";
    private static final String TAG_NAME = "tagName";
    private static final String HTTPS = "https://";

    public static String getStatus(IFlashPlayer iFlashPlayer) {
        if (iFlashPlayer == null) {
            return null;
        }
        IASNode iASNode = iFlashPlayer.getRootNode();
        if (iASNode != null) {
            return STATUS_OK;
        }
        String string = iFlashPlayer.getPlayerProperty(TAG_NAME);
        if (!OBJECT.equalsIgnoreCase(string)) {
            return STATUS_NG;
        }
        if (!iFlashPlayer.isReady()) {
            return STATUS_WAIT;
        }
        if (iFlashPlayer.getContentURL().startsWith(HTTPS)) {
            return STATUS_HTTPS;
        }
        return STATUS_NA;
    }
}

