/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.dom;

import org.eclipse.actf.util.dom.TreeWalkerImpl;
import org.eclipse.actf.util.dom.WhatToShowNodeFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    private Node root;
    private Node current = null;
    private int whatToShow;
    private NodeFilter filter;
    private NodeFilter defaultFilter;
    private boolean entitiyReferenceExpansion;
    private boolean isDetach = false;
    private boolean noFilter = true;
    private boolean isForward = true;
    private TreeWalkerImpl treeWalker;

    public NodeIteratorImpl(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        if (node == null) {
            throw new DOMException(8, "Root can't be a null.");
        }
        this.root = node;
        this.whatToShow = n;
        this.filter = nodeFilter;
        this.noFilter = nodeFilter == null;
        this.entitiyReferenceExpansion = bl;
        this.defaultFilter = new WhatToShowNodeFilter(n);
        this.treeWalker = new TreeWalkerImpl(node, n, nodeFilter, bl);
    }

    private short eval(Node node) {
        short s = this.defaultFilter.acceptNode(node);
        if (this.noFilter || s == 3) {
            return s;
        }
        return this.filter.acceptNode(node);
    }

    public void detach() {
        this.isDetach = true;
        this.root = null;
        this.current = null;
        this.filter = null;
        this.defaultFilter = null;
    }

    public boolean getExpandEntityReferences() {
        return this.entitiyReferenceExpansion;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node nextNode() throws DOMException {
        if (this.isDetach) {
            throw new DOMException(11, String.valueOf(this.getClass().toString()) + " is detached.");
        }
        if (this.current == null) {
            this.treeWalker.setCurrentNode(this.root);
            this.current = this.eval(this.root) == 1 ? this.root : this.treeWalker.nextNode();
            this.isForward = true;
            return this.current;
        }
        if (this.isForward) {
            Node node = this.treeWalker.nextNode();
            if (node == null) {
                return null;
            }
            this.current = node;
            return this.current;
        }
        this.isForward = true;
        return this.current;
    }

    public Node previousNode() throws DOMException {
        if (this.isDetach) {
            throw new DOMException(11, String.valueOf(this.getClass().toString()) + " is detached.");
        }
        if (this.current == null) {
            return null;
        }
        if (!this.isForward) {
            Node node = this.treeWalker.previousNode();
            if (node == null) {
                return null;
            }
            this.current = node;
            return this.current;
        }
        this.isForward = false;
        return this.current;
    }

    private Node nonChildNextNode(Node node) {
        if (node == this.root) {
            return null;
        }
        Node node2 = node.getNextSibling();
        if (node2 != null) {
            return node2;
        }
        Node node3 = this.treeWalker.getParentNode(node);
        while (node3 != null && node3 != this.root) {
            node2 = node3.getNextSibling();
            if (node2 != null) {
                return node2;
            }
            node3 = this.treeWalker.getParentNode(node3);
        }
        return null;
    }

    private Node checkParent(Node node) {
        Node node2 = this.current;
        while (node2 != null && node2 != this.root) {
            if (node2 == node) {
                return node;
            }
            node2 = this.treeWalker.getParentNode(node2);
        }
        return null;
    }

    public void prepareNodeRemove(Node node) {
        Node node2 = this.checkParent(node);
        if (node2 != null) {
            if (this.isForward) {
                this.treeWalker.setCurrentNode(node2);
                this.current = this.treeWalker.previousNode();
            } else {
                this.current = this.nonChildNextNode(node2);
                if (this.current == null) {
                    this.treeWalker.setCurrentNode(node2);
                    this.current = this.treeWalker.previousNode();
                    this.isForward = true;
                } else {
                    this.treeWalker.setCurrentNode(this.current);
                }
            }
        }
    }
}

