/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ruby.core.text.RubyContext;

public class RubyKeyword {
    private final String name;
    private static final Map keywords = new HashMap();
    private final RubyContext introducedContext;
    private static String[] sKeywords = new String[]{"if", "else", "elseif", "unless", "while", "until", "in", "case", "when", "begin", "ensure", "module", "for", "then", "do", "and", "or", "not", "rescue", "return", "break", "next", "yield", "defined?", "super", "def", "undef", "alias", "class", "end", "self", "false", "true", "retry", "nil", "redo", "BEGIN", "END", "__LINE__", "__FILE__", "sub", "sub!", "gsub", "gsub!", "scan", "index", "match", "require"};
    private static Map sKeywordContext = new HashMap();

    static {
        sKeywordContext.put("if", RubyContext.EXPRESSION_START);
        sKeywordContext.put("else", RubyContext.EXPRESSION_START);
        sKeywordContext.put("elseif", RubyContext.EXPRESSION_START);
        sKeywordContext.put("unless", RubyContext.EXPRESSION_START);
        sKeywordContext.put("while", RubyContext.EXPRESSION_START);
        sKeywordContext.put("until", RubyContext.EXPRESSION_START);
        sKeywordContext.put("in", RubyContext.EXPRESSION_START);
        sKeywordContext.put("case", RubyContext.EXPRESSION_START);
        sKeywordContext.put("when", RubyContext.EXPRESSION_START);
        sKeywordContext.put("begin", RubyContext.COMMAND_START);
        sKeywordContext.put("ensure", RubyContext.COMMAND_START);
        sKeywordContext.put("module", RubyContext.COMMAND_START);
        sKeywordContext.put("for", RubyContext.COMMAND_START);
        sKeywordContext.put("then", RubyContext.COMMAND_START);
        sKeywordContext.put("do", RubyContext.COMMAND_START);
        sKeywordContext.put("and", RubyContext.COMMAND_START);
        sKeywordContext.put("or", RubyContext.COMMAND_START);
        sKeywordContext.put("not", RubyContext.COMMAND_START);
        sKeywordContext.put("rescue", RubyContext.KEYWORD_ARGUMENT);
        sKeywordContext.put("return", RubyContext.KEYWORD_ARGUMENT);
        sKeywordContext.put("break", RubyContext.KEYWORD_ARGUMENT);
        sKeywordContext.put("next", RubyContext.KEYWORD_ARGUMENT);
        sKeywordContext.put("yield", RubyContext.ARGUMENT);
        sKeywordContext.put("defined?", RubyContext.ARGUMENT);
        sKeywordContext.put("super", RubyContext.ARGUMENT);
        sKeywordContext.put("def", RubyContext.NAME);
        sKeywordContext.put("undef", RubyContext.NAME);
        sKeywordContext.put("alias", RubyContext.NAME);
        sKeywordContext.put("class", RubyContext.NAME);
        sKeywordContext.put("end", RubyContext.NAME);
        sKeywordContext.put("self", RubyContext.NAME);
        sKeywordContext.put("false", RubyContext.NAME);
        sKeywordContext.put("true", RubyContext.NAME);
        sKeywordContext.put("retry", RubyContext.NAME);
        sKeywordContext.put("nil", RubyContext.NAME);
        sKeywordContext.put("redo", RubyContext.NAME);
        sKeywordContext.put("BEGIN", RubyContext.NAME);
        sKeywordContext.put("END", RubyContext.NAME);
        sKeywordContext.put("__LINE__", RubyContext.NAME);
        sKeywordContext.put("__FILE__", RubyContext.NAME);
        sKeywordContext.put("sub", RubyContext.NAME);
        sKeywordContext.put("sub!", RubyContext.NAME);
        sKeywordContext.put("gsub", RubyContext.NAME);
        sKeywordContext.put("gsub!", RubyContext.NAME);
        sKeywordContext.put("scan", RubyContext.NAME);
        sKeywordContext.put("index", RubyContext.NAME);
        sKeywordContext.put("match", RubyContext.NAME);
    }

    private RubyKeyword(String name, RubyContext introducedContext) {
        this.name = name;
        this.introducedContext = introducedContext;
        keywords.put(name, this);
    }

    public RubyContext getIntroducedContext() {
        return this.introducedContext;
    }

    public String toString() {
        return this.name;
    }

    public static RubyKeyword byName(String name) {
        return RubyKeyword.getKeyword(name, name.length());
    }

    public static String[] findByPrefix(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sKeywords.length) {
            if (sKeywords[i].startsWith(prefix)) {
                result.add(sKeywords[i]);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public static RubyKeyword getKeyword(String str, int len) {
        int i = 0;
        while (i < sKeywords.length) {
            if (sKeywords[i].equals(str)) {
                return new RubyKeyword(str, (RubyContext)sKeywordContext.get(str));
            }
            ++i;
        }
        return null;
    }
}

