/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.blocks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ui.text.blocks.BlocksConfiguration;
import org.eclipse.dltk.ui.text.blocks.IBlockSet;
import org.eclipse.dltk.ui.text.blocks.Instance;
import org.eclipse.dltk.ui.text.blocks.Keyword;
import org.eclipse.dltk.ui.text.util.CollectionUtils;
import org.eclipse.dltk.ui.text.util.IRangeFilter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class Balance {
    private final ArrayList active = new ArrayList();
    private final BlocksConfiguration blocks;

    public Balance(BlocksConfiguration blocks) {
        this.blocks = blocks;
    }

    public Instance.JoinResult process(IDocument document, String match, int offset, Listener listener) {
        Instance instance;
        Keyword keyword = this.blocks.getKeyword(match);
        if (keyword == null) {
            return Instance.JoinResult.UNHANDLED;
        }
        try {
            if (!keyword.getRecognition().canMatchAt(document, offset)) {
                return Instance.JoinResult.UNHANDLED;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        int i = this.active.size() - 1;
        while (i >= 0) {
            instance = (Instance)this.active.get(i);
            Instance.JoinResult result = instance.tryJoinAsRightPeer(keyword, offset);
            switch (result.getId()) {
                case 2: {
                    return Instance.JoinResult.STOP_SEARCH;
                }
                case 3: {
                    CollectionUtils.removeElementsFromIndexToEnd(this.active, i);
                }
                case 1: {
                    if (listener != null) {
                        listener.instanceMatched(instance);
                    }
                    return Instance.JoinResult.HANDLED;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unreachable code");
                }
            }
            --i;
        }
        IBlockSet blockSet = this.blocks.getRootBlockSet().narrowByKeyword(keyword);
        instance = new Instance(blockSet, keyword, offset);
        this.active.add(instance);
        return Instance.JoinResult.HANDLED;
    }

    public Instance.JoinResult process(Instance peer, Listener listener) {
        int i = this.active.size() - 1;
        while (i >= 0) {
            Instance instance = (Instance)this.active.get(i);
            Instance.JoinResult result = instance.tryJoinAsRightPeer(peer, false);
            switch (result.getId()) {
                case 2: {
                    return Instance.JoinResult.STOP_SEARCH;
                }
                case 3: {
                    CollectionUtils.removeElementsFromIndexToEnd(this.active, i);
                }
                case 1: {
                    if (listener != null) {
                        listener.instanceMatched(instance);
                    }
                    return Instance.JoinResult.HANDLED;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unreachable code");
                }
            }
            --i;
        }
        this.active.add(peer);
        return Instance.JoinResult.HANDLED;
    }

    public void addAll(Balance successor, Listener listener) {
        int i = 0;
        while (i < successor.active.size()) {
            Instance peer = (Instance)successor.active.get(i);
            this.process(peer, listener);
            ++i;
        }
        successor.active.clear();
    }

    public boolean isAnythingOpen() {
        int i = this.active.size() - 1;
        while (i >= 0) {
            Instance instance = (Instance)this.active.get(i);
            if (instance.getBeginningOffset() >= 0 || instance.getMiddleOffset() >= 0) {
                return true;
            }
            --i;
        }
        return false;
    }

    public String toDebugString(IDocument document) {
        StringBuffer r = new StringBuffer();
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            Instance item = (Instance)iter.next();
            if (r.length() > 0) {
                r.append(' ');
            }
            item.addToDebugString(r, document);
        }
        return r.toString();
    }

    public static Balance calculateBalance(IDocument document, int startOffset, int length, BlocksConfiguration blocks, IRangeFilter rangeFilter, Listener listener) throws BadLocationException {
        Balance balance = new Balance(blocks);
        String data = document.get(startOffset, length);
        Pattern regularExpression = blocks.getBeginMiddleEndPattern();
        Matcher matcher = regularExpression.matcher(data);
        boolean found = matcher.find();
        while (found) {
            String match = matcher.group();
            int start = startOffset + matcher.start();
            if (rangeFilter.allowRange(document, start, match.length())) {
                balance.process(document, match, start, listener);
            }
            found = matcher.find();
        }
        return balance;
    }

    public static interface Listener {
        public void instanceMatched(Instance var1);
    }
}

