/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.codeassist.ISelectionEngine;
import org.eclipse.dltk.compiler.problem.DLTKProblemReporter;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.util.Messages;

public abstract class AbstractLanguageToolkit
implements IDLTKLanguageToolkit {
    public IProblemFactory createProblemFactory() {
        return new DefaultProblemFactory();
    }

    public IProblemReporter createProblemReporter(IResource resource, IProblemFactory factory) {
        block2: {
            try {
                resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return new DLTKProblemReporter(resource, factory);
    }

    protected abstract String getCorePluginID();

    public IStatus validateSourceModule(String name) {
        if (name == null) {
            return new Status(4, this.getCorePluginID(), -1, Messages.convention_unit_nullName, null);
        }
        if (!this.isScriptLikeFileName(name)) {
            return new Status(4, this.getCorePluginID(), -1, MessageFormat.format(Messages.convention_unit_notScriptName, "", ""), null);
        }
        return IModelStatus.VERIFIED_OK;
    }

    private boolean isScriptLikeFileName(String name) {
        String[] extensions = this.getLanguageFileExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (name.endsWith("." + extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean languageSupportZIPBuildpath() {
        return false;
    }

    public boolean validateSourcePackage(IPath path) {
        return true;
    }

    public ICompletionEngine createCompletionEngine(ISearchableEnvironment environment, CompletionRequestor requestor, Map options, IScriptProject project) {
        return null;
    }

    public IMatchLocatorParser createMatchParser(MatchLocator locator) {
        return null;
    }

    public IStatus validateSourceModule(IResource resource) {
        return this.validateSourceModule(resource.getName());
    }

    public IStatus validateSourceModule(IPath resource) {
        return this.validateSourceModule(resource.lastSegment());
    }

    public IStatus validateSourceModuleName(String str) {
        return this.validateSourceModule(str);
    }

    public String getEditorID(Object inputElement) {
        return null;
    }

    public ISelectionEngine createSelectionEngine(ISearchableEnvironment environment, Map options) {
        return null;
    }

    public SourceIndexerRequestor createSourceRequestor() {
        return new SourceIndexerRequestor();
    }

    public DLTKSearchParticipant createSearchParticipant() {
        return null;
    }

    public MatchLocator createMatchLocator(SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, SubProgressMonitor monitor) {
        return null;
    }

    public ICalleeProcessor createCalleeProcessor(IMethod method, IProgressMonitor monitor, IDLTKSearchScope scope) {
        return null;
    }

    public String getDelimeterReplacerString() {
        return ".";
    }

    public ICallProcessor createCallProcessor() {
        return null;
    }

    public abstract String[] getLanguageFileExtensions();

    public IType[] getParentTypes(IType type) {
        return null;
    }
}

