/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import org.eclipse.dltk.internal.corext.callhierarchy.CallLocation;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class LocationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int COLUMN_ICON = 0;
    private static final int COLUMN_LINE = 1;
    private static final int COLUMN_INFO = 2;

    LocationLabelProvider() {
    }

    public String getText(Object element) {
        return this.getColumnText(element, 2);
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    private String removeWhitespaceOutsideStringLiterals(CallLocation callLocation) {
        StringBuffer buf = new StringBuffer();
        boolean withinString = false;
        String s = callLocation.getCallText();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                boolean bl = withinString = !withinString;
            }
            if (withinString) {
                buf.append(ch);
            } else if (Character.isWhitespace(ch)) {
                if (buf.length() == 0 || !Character.isWhitespace(buf.charAt(buf.length() - 1))) {
                    if (ch != ' ') {
                        ch = ' ';
                    }
                    buf.append(ch);
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return DLTKPluginImages.get("org.eclipse.dltk.ui.occ_match.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof CallLocation) {
            CallLocation callLocation = (CallLocation)element;
            switch (columnIndex) {
                case 1: {
                    int lineNumber = callLocation.getLineNumber();
                    if (lineNumber == -1) {
                        return CallHierarchyMessages.LocationLabelProvider_unknown;
                    }
                    return String.valueOf(lineNumber);
                }
                case 2: {
                    return this.removeWhitespaceOutsideStringLiterals(callLocation);
                }
            }
        }
        return "";
    }
}

