/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.dltk.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReorgMoveWizard
extends RefactoringWizard {
    static /* synthetic */ Class class$0;

    public ReorgMoveWizard(MoveRefactoring ref) {
        super((Refactoring)ref, 4 | ReorgMoveWizard.computeHasPreviewPage(ref));
        if (ReorgMoveWizard.isTextualMove(ref)) {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_textual_move);
        } else {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_3);
        }
    }

    private static boolean isTextualMove(MoveRefactoring ref) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ScriptMoveProcessor moveProcessor = (ScriptMoveProcessor)ref.getAdapter((Class)clazz);
        return moveProcessor.isTextualMove();
    }

    private static int computeHasPreviewPage(MoveRefactoring refactoring) {
        ScriptMoveProcessor processor;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((processor = (ScriptMoveProcessor)refactoring.getAdapter((Class)clazz)).canUpdateReferences() || processor.canEnableQualifiedNameUpdating()) {
            return 0;
        }
        return 16;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInputPage());
    }

    private static class MoveInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "MoveInputPage";
        private Button fReferenceCheckbox;
        private Button fQualifiedNameCheckbox;
        private QualifiedNameComponent fQualifiedNameComponent;
        private ICreateTargetQuery fCreateTargetQuery;
        private Object fDestination;

        public MoveInputPage() {
            super(PAGE_NAME);
        }

        private ScriptMoveProcessor getScriptMoveProcessor() {
            Refactoring refactoring = this.getRefactoring();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ScriptMoveProcessor)refactoring.getAdapter((Class)clazz);
        }

        protected Object getInitiallySelectedElement() {
            return this.getScriptMoveProcessor().getCommonParentForInputElements();
        }

        protected IModelElement[] getScriptElements() {
            return this.getScriptMoveProcessor().getScriptElements();
        }

        protected IResource[] getResources() {
            return this.getScriptMoveProcessor().getResources();
        }

        protected IReorgDestinationValidator getDestinationValidator() {
            return this.getScriptMoveProcessor();
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getScriptMoveProcessor().wasCanceled();
        }

        protected RefactoringStatus verifyDestination(Object selected) throws ModelException {
            ScriptMoveProcessor processor = this.getScriptMoveProcessor();
            RefactoringStatus refactoringStatus = selected instanceof IModelElement ? processor.setDestination((IModelElement)selected) : (selected instanceof IResource ? processor.setDestination((IResource)selected) : RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.ReorgMoveWizard_4));
            this.updateUIStatus();
            this.fDestination = selected;
            return refactoringStatus;
        }

        private void updateUIStatus() {
            this.getRefactoringWizard().setForcePreviewReview(false);
            ScriptMoveProcessor processor = this.getScriptMoveProcessor();
            if (this.fReferenceCheckbox != null) {
                this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
                processor.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
            }
            if (this.fQualifiedNameCheckbox != null) {
                boolean enabled = processor.canEnableQualifiedNameUpdating();
                this.fQualifiedNameCheckbox.setEnabled(enabled);
                if (enabled) {
                    this.fQualifiedNameComponent.setEnabled(processor.getUpdateQualifiedNames());
                    if (processor.getUpdateQualifiedNames()) {
                        this.getRefactoringWizard().setForcePreviewReview(true);
                    }
                } else {
                    this.fQualifiedNameComponent.setEnabled(false);
                }
                processor.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
            }
        }

        private void addUpdateReferenceComponent(Composite result) {
            ScriptMoveProcessor processor = this.getScriptMoveProcessor();
            if (!processor.canUpdateReferences()) {
                return;
            }
            this.fReferenceCheckbox = new Button(result, 32);
            this.fReferenceCheckbox.setText(ReorgMessages.ScriptMoveAction_update_references);
            this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
            this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, processor){
                final /* synthetic */ MoveInputPage this$1;
                private final /* synthetic */ ScriptMoveProcessor val$processor;
                {
                    this.this$1 = moveInputPage;
                    this.val$processor = scriptMoveProcessor;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$processor.setUpdateReferences(((Button)e.widget).getSelection());
                    MoveInputPage.access$0(this.this$1);
                }
            });
        }

        private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
            ScriptMoveProcessor processor = this.getScriptMoveProcessor();
            if (!processor.canEnableQualifiedNameUpdating() || !processor.canUpdateQualifiedNames()) {
                return;
            }
            this.fQualifiedNameCheckbox = new Button(parent, 32);
            int indent = marginWidth + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
            this.fQualifiedNameCheckbox.setText(RefactoringMessages.RenameInputWizardPage_update_qualified_names);
            this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
            this.fQualifiedNameCheckbox.setSelection(processor.getUpdateQualifiedNames());
            this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, processor, this.getRefactoringSettings());
            this.fQualifiedNameComponent.setLayoutData(new GridData(768));
            GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = indent;
            this.updateQualifiedNameUpdating(processor, processor.getUpdateQualifiedNames());
            this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, processor){
                final /* synthetic */ MoveInputPage this$1;
                private final /* synthetic */ ScriptMoveProcessor val$processor;
                {
                    this.this$1 = moveInputPage;
                    this.val$processor = scriptMoveProcessor;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.widget).getSelection();
                    MoveInputPage.access$1(this.this$1, this.val$processor, enabled);
                }
            });
        }

        private void updateQualifiedNameUpdating(ScriptMoveProcessor processor, boolean enabled) {
            this.fQualifiedNameComponent.setEnabled(enabled);
            processor.setUpdateQualifiedNames(enabled);
            this.updateUIStatus();
        }

        public void createControl(Composite parent) {
            Composite result;
            boolean showDestinationTree;
            boolean bl = showDestinationTree = !this.getScriptMoveProcessor().hasDestinationSet();
            if (showDestinationTree) {
                this.fCreateTargetQuery = this.getScriptMoveProcessor().getCreateTargetQuery();
                super.createControl(parent);
                this.getTreeViewer().getTree().setFocus();
                result = (Composite)super.getControl();
            } else {
                this.initializeDialogUnits((Control)parent);
                result = new Composite(parent, 0);
                this.setControl((Control)result);
                result.setLayout((Layout)new GridLayout());
                Dialog.applyDialogFont((Control)result);
            }
            this.addUpdateReferenceComponent(result);
            this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
            this.setControl((Control)result);
            Dialog.applyDialogFont((Control)result);
        }

        protected Control addLabel(Composite parent) {
            if (this.fCreateTargetQuery != null) {
                Composite firstLine = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                firstLine.setLayout((Layout)layout);
                firstLine.setLayoutData((Object)new GridData(768));
                Control label = super.addLabel(firstLine);
                label.addTraverseListener(new TraverseListener(this){
                    final /* synthetic */ MoveInputPage this$1;
                    {
                        this.this$1 = moveInputPage;
                    }

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 128 && e.doit) {
                            e.detail = 0;
                            this.this$1.getTreeViewer().getTree().setFocus();
                        }
                    }
                });
                Button newButton = new Button(firstLine, 8);
                newButton.setText(this.fCreateTargetQuery.getNewButtonLabel());
                GridData gd = new GridData(642);
                gd.widthHint = SWTUtil.getButtonWidthHint(newButton);
                newButton.setLayoutData((Object)gd);
                newButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ MoveInputPage this$1;
                    {
                        this.this$1 = moveInputPage;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        MoveInputPage.access$2(this.this$1);
                    }
                });
                return firstLine;
            }
            return super.addLabel(parent);
        }

        private boolean canUpdateReferences() {
            return this.getScriptMoveProcessor().canUpdateReferences();
        }

        private void doNewButtonPressed() {
            Object newElement = this.fCreateTargetQuery.getCreatedTarget(this.fDestination);
            if (newElement != null) {
                TreeViewer viewer = this.getTreeViewer();
                ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
                viewer.refresh(contentProvider.getParent(newElement));
                viewer.setSelection((ISelection)new StructuredSelection(newElement), true);
                viewer.getTree().setFocus();
            }
        }

        static /* synthetic */ void access$0(MoveInputPage moveInputPage) {
            moveInputPage.updateUIStatus();
        }

        static /* synthetic */ void access$1(MoveInputPage moveInputPage, ScriptMoveProcessor scriptMoveProcessor, boolean bl) {
            moveInputPage.updateQualifiedNameUpdating(scriptMoveProcessor, bl);
        }

        static /* synthetic */ void access$2(MoveInputPage moveInputPage) {
            moveInputPage.doNewButtonPressed();
        }
    }
}

