/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IProjectFragmentManipulationQuery;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteProjectFragmentChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final boolean fIsExecuteChange;
    private final IProjectFragmentManipulationQuery fUpdateClasspathQuery;

    public DeleteProjectFragmentChange(IProjectFragment root, boolean isExecuteChange, IProjectFragmentManipulationQuery updateClasspathQuery) {
        Assert.isNotNull((Object)root);
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fHandle = root.getHandleIdentifier();
        this.fIsExecuteChange = isExecuteChange;
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    public String getName() {
        Object[] keys = new String[]{this.getRoot().getElementName()};
        return Messages.format(RefactoringCoreMessages.DeleteProjectFragmentChange_delete, keys);
    }

    public Object getModifiedElement() {
        return this.getRoot();
    }

    private IProjectFragment getRoot() {
        return (IProjectFragment)DLTKCore.create((String)this.fHandle);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(pm, 2);
        }
        return super.isValid(pm, 3);
    }

    protected void doDelete(IProgressMonitor pm) throws CoreException {
        if (!this.confirmDeleteIfReferenced()) {
            return;
        }
        int resourceUpdateFlags = 2;
        int jCoreUpdateFlags = 6;
        this.getRoot().delete(resourceUpdateFlags, jCoreUpdateFlags, pm);
    }

    private boolean confirmDeleteIfReferenced() throws ModelException {
        if (!this.getRoot().isArchive()) {
            return true;
        }
        if (this.fUpdateClasspathQuery == null) {
            return true;
        }
        IScriptProject[] referencingProjects = ModelElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length == 0) {
            return true;
        }
        return this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
    }
}

