/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;

public class BasicContext
implements IContext,
ISourceModuleContext {
    private final ISourceModule sourceModule;
    private final ModuleDeclaration rootNode;

    public BasicContext(ISourceModule sourceModule, ModuleDeclaration rootNode) {
        this.sourceModule = sourceModule;
        this.rootNode = rootNode;
    }

    public BasicContext(ISourceModuleContext parent) {
        this.sourceModule = parent.getSourceModule();
        this.rootNode = parent.getRootNode();
    }

    public ModuleDeclaration getRootNode() {
        return this.rootNode;
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    public String getLangNature() {
        if (this.sourceModule != null) {
            try {
                IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit(this.sourceModule);
                if (languageToolkit != null) {
                    return languageToolkit.getNatureId();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        return "BasicContext, module " + this.sourceModule.getElementName();
    }
}

