/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.ruby.internal.parser.visitors.RubySourceElementRequestor;

public class RubySourceElementParser
implements ISourceElementParser {
    public static final Object AST = "ast";
    private ISourceElementRequestor fRequestor = null;
    private IProblemReporter problemReporter;

    public ModuleDeclaration parseSourceModule(char[] contents, ISourceModuleInfoCache.ISourceModuleInfo astCashe, char[] filename) {
        ModuleDeclaration moduleDeclaration;
        block2: {
            moduleDeclaration = RubySourceElementParser.parseModule(astCashe, contents, this.problemReporter, filename);
            RubySourceElementRequestor requestor = new RubySourceElementRequestor(this.fRequestor);
            try {
                moduleDeclaration.traverse((ASTVisitor)requestor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return moduleDeclaration;
    }

    public static ModuleDeclaration parseModule(ISourceModuleInfoCache.ISourceModuleInfo astCache, char[] content, IProblemReporter problemReporter, char[] filename) {
        ModuleDeclaration moduleDeclaration = null;
        if (astCache != null) {
            moduleDeclaration = (ModuleDeclaration)astCache.get(AST);
        }
        if (moduleDeclaration == null) {
            ISourceParser sourceParser = null;
            try {
                sourceParser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (sourceParser != null && (moduleDeclaration = sourceParser.parse(filename, content, problemReporter)) != null && astCache != null) {
                astCache.put(AST, (Object)moduleDeclaration);
            }
        }
        return moduleDeclaration;
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.fRequestor = requestor;
    }

    public static ModuleDeclaration parseModule(ISourceModule module) {
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        try {
            return RubySourceElementParser.parseModule(sourceModuleInfoCache.get(module), module.getSourceAsCharArray(), null, null);
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public void setReporter(IProblemReporter reporter) {
        this.problemReporter = reporter;
    }
}

