/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclSelectionParser;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnAST;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnVariable;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclSelectionEngine
extends ScriptSelectionEngine {
    public static boolean DEBUG = DLTKCore.DEBUG_SELECTION;
    private int actualSelectionStart;
    private int actualSelectionEnd;
    private List selectionElements = new ArrayList();
    private TclSelectionParser parser = new TclSelectionParser();
    private org.eclipse.dltk.core.ISourceModule sourceModule;
    private IDLTKLanguageToolkit toolkit;
    private TclParseUtils.IProcessStatementAction processBlockAction = new TclParseUtils.IProcessStatementAction(){

        public void doAction(String name, Expression bl, int beforePosition) {
            if (bl instanceof TclBlockExpression) {
                TclSelectionEngine.this.processBlock(name, bl, beforePosition);
            }
            if (bl instanceof TclExecuteExpression) {
                TclSelectionEngine.this.processExecuteBlock(name, bl, beforePosition);
            }
        }
    };

    public TclSelectionEngine() {
        this.toolkit = TclLanguageToolkit.getDefault();
    }

    public IModelElement[] select(ISourceModule sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        block12: {
            this.sourceModule = (org.eclipse.dltk.core.ISourceModule)sourceUnit.getModelElement();
            String content = sourceUnit.getSourceContents();
            if (DEBUG) {
                System.out.print("SELECTION IN ");
                System.out.print(sourceUnit.getFileName());
                System.out.print(" FROM ");
                System.out.print(selectionSourceStart);
                System.out.print(" TO ");
                System.out.println(selectionSourceEnd);
                System.out.println("SELECTION - Source :");
                System.out.println(content);
            }
            if (!this.checkSelection(content, selectionSourceStart, selectionSourceEnd)) {
                return new IModelElement[0];
            }
            if (DEBUG) {
                System.out.print("SELECTION - Checked : \"");
                System.out.print(content.substring(this.actualSelectionStart, this.actualSelectionEnd));
                System.out.println('\"');
            }
            try {
                ModuleDeclaration parsedUnit = this.parser.parse(sourceUnit);
                if (parsedUnit == null) break block12;
                try {
                    this.lookupEnvironment.buildTypeScope(parsedUnit, null);
                    this.unitScope = parsedUnit.scope;
                    if (this.unitScope != null) {
                        this.parseBlockStatements(parsedUnit, this.actualSelectionStart);
                        if (DEBUG) {
                            System.out.println("COMPLETION - AST :");
                            System.out.println(parsedUnit.toString());
                        }
                    }
                }
                catch (SelectionNodeFound e) {
                    if (e.getNode() != null) {
                        if (DEBUG) {
                            System.out.print("COMPLETION - Completion node : ");
                            System.out.println(e.getNode().toString());
                            if (this.parser.getAssistNodeParent() != null) {
                                System.out.print("COMPLETION - Parent Node : ");
                                System.out.println(this.parser.getAssistNodeParent());
                            }
                        }
                        this.select(e.getNode(), this.parser.getAssistNodeParent());
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (!DEBUG) break block12;
                System.out.println("Exception caught by SelectionEngine:");
                e.printStackTrace(System.out);
            }
        }
        return this.selectionElements.toArray(new IModelElement[this.selectionElements.size()]);
    }

    private void select(ASTNode astNode, ASTNode astNodeParent) {
        if (astNode instanceof SelectionOnKeywordOrFunction) {
            SelectionOnKeywordOrFunction key = (SelectionOnKeywordOrFunction)astNode;
            String name = key.getName();
            if (name != null) {
                this.findLocalFunctions(name, astNodeParent);
                if (this.selectionElements.size() > 0) {
                    return;
                }
                this.findMethodFromSearch(name);
                if (this.selectionElements.size() > 0) {
                    return;
                }
                String fqnName = null;
                if (astNodeParent instanceof TypeDeclaration) {
                    TypeDeclaration t = (TypeDeclaration)astNodeParent;
                    fqnName = String.valueOf(t.getEnclosingTypeName()) + "::" + t.getName() + "::" + name;
                } else if (astNodeParent instanceof MethodDeclaration) {
                    MethodDeclaration t = (MethodDeclaration)astNodeParent;
                    fqnName = String.valueOf(t.getDeclaringTypeName()) + "::" + name;
                }
                if (fqnName != null) {
                    if (!fqnName.startsWith("::")) {
                        fqnName = "::" + fqnName;
                    }
                    this.findMethodFromSearch(fqnName);
                }
            }
        } else if (astNode instanceof SelectionOnVariable) {
            SelectionOnVariable completion = (SelectionOnVariable)astNode;
            this.findVariables(completion.getName(), astNodeParent, astNode.sourceStart());
        } else if (astNode instanceof SelectionOnAST) {
            this.addElementFromASTNode(((SelectionOnAST)astNode).getNode());
        }
    }

    private void findVariables(String name, ASTNode parent, int beforePosition) {
        if (parent instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)parent;
            List statements = method.getArguments();
            if (statements != null) {
                int i = 0;
                while (i < statements.size()) {
                    Argument a = (Argument)statements.get(i);
                    if (a != null) {
                        this.checkVariable(name, a.getName(), (ASTNode)method);
                    }
                    ++i;
                }
            }
            statements = method.getStatements();
            this.checkVariableStatements(name, beforePosition, statements, "");
        } else if (parent instanceof ModuleDeclaration) {
            ModuleDeclaration module = (ModuleDeclaration)parent;
            this.checkVariableStatements(name, beforePosition, module.getStatements(), "");
        } else if (parent instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)parent;
            this.checkVariableStatements(name, beforePosition, type.getStatements(), "");
        } else {
            List levels = this.parser.findLevelsTo(parent);
            ASTNode realParent = this.findRealParent(levels);
            if (realParent != null) {
                this.findVariables(name, realParent, beforePosition);
            }
        }
        if (this.selectionElements.size() > 0) {
            return;
        }
        if (name.startsWith("$")) {
            block16: {
                if (!(name = name.substring(1)).startsWith("::")) {
                    name = "::" + name;
                }
                String typeName = name.substring(0, name.lastIndexOf("::"));
                String varName = name.substring(name.lastIndexOf("::") + 2);
                typeName = typeName.replaceAll("::", "\\$");
                try {
                    IModelElement field;
                    Object type = null;
                    type = typeName.length() > 0 ? (IModelElement)this.findTypeFrom(this.sourceModule.getChildren(), "", typeName, '$') : this.sourceModule;
                    if (type != null && type instanceof IParent && (field = this.findChildrenByName(varName, (IParent)type)) != null) {
                        this.selectionElements.add(field);
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block16;
                    e.printStackTrace();
                }
            }
            this.findFieldFromSearch(name);
        }
    }

    private void findFieldFromSearch(String varName) {
        if (this.selectionElements.size() > 0) {
            return;
        }
        if (varName.startsWith("$")) {
            varName = varName.substring(1);
        }
        final String name = varName;
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    IType type = (IType)element;
                    IField[] tfields = type.getFields();
                    int i = 0;
                    while (i < tfields.length) {
                        this.processField(name, tfields[i]);
                        ++i;
                    }
                } else if (element instanceof IField) {
                    IField field = (IField)element;
                    this.processField(name, field);
                }
            }

            private void processField(String name2, IField field) {
                String mn = TclParseUtils.processFieldName(field, name2);
                if (mn.equals(name2) && !TclSelectionEngine.this.selectionElements.contains(field)) {
                    TclSelectionEngine.this.selectionElements.add(field);
                }
            }
        };
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.toolkit);
        if (name != null && name.length() >= 3 && name.charAt(0) == ':') {
            try {
                this.search(name, 0, 0, scope, requestor);
                this.search(name, 2, 0, scope, requestor);
                if (name.startsWith("::")) {
                    String name_wo = name.substring(2);
                    this.search(name_wo, 0, 0, scope, requestor);
                    this.search(name_wo, 2, 0, scope, requestor);
                }
                String to = new String(name);
                String[] tokens = to.split("::");
                String tok = tokens[1];
                try {
                    this.search(to, 2, 0, scope, requestor);
                    this.search(to, 2, 0, scope, requestor);
                    this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                    if (to.startsWith("::")) {
                        String to_wo = to.substring(2);
                        this.search(String.valueOf(new String(to_wo)) + "*", 2, 0, scope, requestor);
                    }
                    this.search(String.valueOf(new String(tok)) + "*", 1, 0, scope, requestor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (name != null && name.length() >= 1 && name.charAt(0) != ':') {
            try {
                this.search(name, 2, 0, scope, requestor);
                this.search(name, 0, 0, scope, requestor);
                String[] tokens = name.split("::");
                String tok = tokens[0];
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private ASTNode findRealParent(List levels) {
        int i = levels.size() - 1;
        while (i >= 0) {
            ASTNode n = (ASTNode)levels.get(i);
            if (n instanceof MethodDeclaration || n instanceof TypeDeclaration || n instanceof ModuleDeclaration) {
                return n;
            }
            --i;
        }
        return null;
    }

    private void checkVariableStatements(String name, int beforePosition, List statements, String prefix) {
        if (statements != null) {
            int i = 0;
            while (i < statements.size()) {
                Expression commandId;
                TclStatement s;
                String[] variable;
                ASTNode node = (ASTNode)statements.get(i);
                if (node instanceof TclStatement && node.sourceEnd() < beforePosition && (variable = TclParseUtils.returnVariable(s = (TclStatement)node)) != null) {
                    int u = 0;
                    while (u < variable.length) {
                        this.checkVariable(name, String.valueOf(prefix) + variable[u], node);
                        ++u;
                    }
                }
                if (node instanceof TypeDeclaration) {
                    TypeDeclaration type = (TypeDeclaration)node;
                    String nn = type.getName();
                    if (nn.startsWith("::")) {
                        nn = nn.substring(2);
                    }
                    this.checkVariableStatements(name, beforePosition, type.getStatements(), String.valueOf(prefix) + nn + "::");
                }
                if (node instanceof TclStatement && node.sourceStart() <= beforePosition && (commandId = (s = (TclStatement)node).getAt(0)) != null && commandId instanceof SimpleReference) {
                    String qname = ((SimpleReference)commandId).getName();
                    if (qname.equals("if")) {
                        TclParseUtils.processIf(s.getExpressions(), name, beforePosition, this.processBlockAction);
                    } else if (qname.equals("while")) {
                        this.processWhile(name, s, beforePosition, this.processBlockAction);
                    } else if (qname.equals("for")) {
                        this.processFor(name, s, beforePosition, this.processBlockAction);
                    } else if (qname.equals("catch")) {
                        this.processCatch(name, s, beforePosition, this.processBlockAction);
                    }
                }
                ++i;
            }
        }
    }

    private void processBlock(String name, Expression bl, int beforePosition) {
        TclBlockExpression block = (TclBlockExpression)bl;
        List code = null;
        code = block.parseBlock(block.sourceStart() + 1);
        this.checkVariableStatements(name, beforePosition, code, "");
    }

    private void processExecuteBlock(String name, Expression bl, int beforePosition) {
        TclExecuteExpression block = (TclExecuteExpression)bl;
        List code = block.parseExpression(block.sourceStart() + 1);
        this.checkVariableStatements(name, beforePosition, code, "");
    }

    private void processFor(String name, TclStatement statement, int beforePosition, TclParseUtils.IProcessStatementAction action) {
        Expression bl;
        int bi;
        Expression bl2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (1 < len && (bl2 = (Expression)exprs.get(1)) instanceof TclBlockExpression) {
            action.doAction(name, bl2, beforePosition);
        }
        if ((bi = 4) < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            action.doAction(name, bl, beforePosition);
        }
    }

    private void processWhile(String name, TclStatement statement, int beforePosition, TclParseUtils.IProcessStatementAction action) {
        Expression bl;
        int bi = 2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (bi < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            action.doAction(name, bl, beforePosition);
        }
    }

    private void processCatch(String name, TclStatement statement, int beforePosition, TclParseUtils.IProcessStatementAction action) {
        Expression bl;
        int bi = 1;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (bi < len && ((bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression || bl instanceof TclExecuteExpression)) {
            action.doAction(name, bl, beforePosition);
        }
    }

    private void processAfter(String name, TclStatement statement, int beforePosition, TclParseUtils.IProcessStatementAction action) {
        Expression bl;
        int bi = 2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (bi < len && ((bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression || bl instanceof TclExecuteExpression)) {
            action.doAction(name, bl, beforePosition);
        }
    }

    private void checkVariable(String name, String variable, ASTNode node) {
        if (variable.indexOf(40) != -1) {
            variable = variable.substring(0, variable.indexOf(40));
        }
        String str = name.startsWith("${") ? "${" + variable + '}' : "$" + variable;
        if (name.indexOf(40) != -1) {
            name = name.substring(0, name.indexOf(40));
        }
        if (name.equals(str)) {
            this.addElementFromASTNode(node);
        }
    }

    private void findMethodFromSearch(final String name) {
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    IType type = (IType)element;
                    String mn = TclParseUtils.processTypeName(type, name);
                    if (mn.equals(name) && !TclSelectionEngine.this.selectionElements.contains(type)) {
                        TclSelectionEngine.this.selectionElements.add(type);
                    }
                    IMethod[] tmethods = type.getMethods();
                    int i = 0;
                    while (i < tmethods.length) {
                        this.processMethod(name, tmethods[i]);
                        ++i;
                    }
                } else if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    this.processMethod(name, method);
                }
            }

            private void processMethod(String name2, IMethod method) {
                String mn = TclParseUtils.processMethodName(method, name2);
                if (mn.equals(name2) && !TclSelectionEngine.this.selectionElements.contains(method)) {
                    TclSelectionEngine.this.selectionElements.add(method);
                }
            }
        };
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.toolkit);
        if (name != null && name.length() >= 3 && name.charAt(0) == ':') {
            try {
                this.search(name, 0, 0, scope, requestor);
                this.search(name, 1, 0, scope, requestor);
                if (name.startsWith("::")) {
                    String name_wo = name.substring(2);
                    this.search(name_wo, 0, 0, scope, requestor);
                    this.search(name_wo, 1, 0, scope, requestor);
                }
                String to = new String(name);
                String[] tokens = to.split("::");
                String tok = tokens[1];
                try {
                    this.search(to, 1, 0, scope, requestor);
                    this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                    if (to.startsWith("::")) {
                        String to_wo = to.substring(2);
                        this.search(String.valueOf(new String(to_wo)) + "*", 1, 0, scope, requestor);
                    }
                    this.search(String.valueOf(new String(tok)) + "*", 1, 0, scope, requestor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (name != null && name.length() >= 1 && name.charAt(0) != ':') {
            try {
                this.search(name, 1, 0, scope, requestor);
                this.search(name, 0, 0, scope, requestor);
                String[] tokens = name.split("::");
                String tok = tokens[0];
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    private void findLocalFunctions(String name, ASTNode parent) {
        MethodDeclaration mParent;
        String pName;
        List levels = this.parser.findLevelsTo(parent);
        int len = levels.size();
        ASTNode realParent = this.findRealParent(levels);
        if (realParent instanceof MethodDeclaration && !name.startsWith("::") && (pName = (mParent = (MethodDeclaration)realParent).getName()).indexOf("::") != -1) {
            pName = pName.substring(0, pName.lastIndexOf("::") + 2);
            this.processFindLocalFunctions(String.valueOf(pName) + name, levels, len);
        }
        this.processFindLocalFunctions(name, levels, len);
    }

    private void processFindLocalFunctions(String name, List levels, int len) {
        ArrayList visited = new ArrayList();
        int j = 0;
        while (j < len) {
            List statements;
            TypeDeclaration decl;
            ASTNode astNodeParent = (ASTNode)levels.get(len - 1 - j);
            boolean topLevel = false;
            if (name != null && name.length() > 0 && name.charAt(0) == ':') {
                topLevel = true;
            }
            if (astNodeParent instanceof TypeDeclaration && !topLevel) {
                decl = (TypeDeclaration)astNodeParent;
                statements = decl.getStatements();
                if (statements != null) {
                    this.processMethods(name, statements, "", visited);
                    if (!name.startsWith("::")) {
                        this.processMethods(String.valueOf(decl.getName()) + "::" + name, statements, "", visited);
                    }
                    if (this.selectionElements.size() > 0) {
                        return;
                    }
                }
            } else if (astNodeParent instanceof ModuleDeclaration) {
                decl = (ModuleDeclaration)astNodeParent;
                statements = decl.getStatements();
                this.processMethods(name, statements, "", visited);
                if (statements != null && this.selectionElements.size() > 0) {
                    return;
                }
            }
            ++j;
        }
    }

    private void processMethods(String name, List statements, String namePrefix, List visited) {
        if (this.selectionElements.size() > 0) {
            return;
        }
        int i = 0;
        while (i < statements.size()) {
            ASTNode nde = (ASTNode)statements.get(i);
            if (nde instanceof MethodDeclaration) {
                String mName = ((MethodDeclaration)nde).getName();
                if (!mName.startsWith("::")) {
                    mName = String.valueOf(namePrefix) + mName;
                }
                if (mName.startsWith("::::")) {
                    mName = mName.substring(2);
                }
                if (name.startsWith("::")) {
                    name = name.substring(2);
                }
                if (mName.startsWith("::")) {
                    mName = mName.substring(2);
                }
                if (name.equals(mName)) {
                    this.addElementFromASTNode(nde);
                    if (this.selectionElements.size() > 0) {
                        return;
                    }
                }
            } else if (nde instanceof TypeDeclaration && !visited.contains(nde)) {
                List tStatements = ((TypeDeclaration)nde).getStatements();
                visited.add(nde);
                String ndeName = ((TypeDeclaration)nde).getName();
                if (ndeName.startsWith("::")) {
                    this.processMethods(name, tStatements, String.valueOf(ndeName) + "::", visited);
                } else {
                    this.processMethods(name, tStatements, String.valueOf(namePrefix) + ndeName + "::", visited);
                }
            }
            visited.add(nde);
            ++i;
        }
    }

    private void addElementFromASTNode(ASTNode nde) {
        ModuleDeclaration module = this.parser.module;
        List statements = module.getStatements();
        this.searchAddElementsTo(statements, nde, (IParent)this.sourceModule);
    }

    private IParent findTypeFrom(IModelElement[] childs, String name, String parentName, char delimiter) {
        try {
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof IType) {
                    IType type = (IType)childs[i];
                    String qname = String.valueOf(name) + delimiter + type.getElementName();
                    if (qname.equals(parentName)) {
                        return type;
                    }
                    IParent val = this.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                    if (val != null) {
                        return val;
                    }
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void searchAddElementsTo(List statements, final ASTNode node, IParent element) {
        if (statements == null || element == null) {
            return;
        }
        Iterator i = statements.iterator();
        while (i.hasNext()) {
            ASTNode nde = (ASTNode)i.next();
            if (nde.equals(node)) {
                String nodeName;
                String oName;
                if (node instanceof MethodDeclaration && (oName = ((MethodDeclaration)node).getName()).indexOf("::") != -1) {
                    String pName = oName.substring(0, oName.lastIndexOf("::"));
                    if ((pName = pName.replaceAll("::", "\\$")).startsWith("$")) {
                        if (pName.equals("$")) {
                            element = this.sourceModule;
                        } else {
                            try {
                                element = this.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                            }
                            catch (ModelException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        pName = "$" + pName;
                        try {
                            element = this.findTypeFrom(element.getChildren(), "", pName, '$');
                            if (element == null) {
                                return;
                            }
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }
                if ((nodeName = this.getNodeChildName(node)) != null) {
                    IModelElement e = null;
                    if (nodeName.startsWith("::")) {
                        nodeName = nodeName.substring(2);
                        e = this.findChildrenByName(nodeName, (IParent)this.sourceModule);
                    } else {
                        e = this.findChildrenByName(nodeName, element);
                    }
                    if (e != null) {
                        ArrayList<IModelElement> toRemove = new ArrayList<IModelElement>();
                        int k = 0;
                        while (k < this.selectionElements.size()) {
                            IModelElement ke = (IModelElement)this.selectionElements.get(k);
                            String keName = ke.getElementName();
                            if (keName.equals(nodeName)) {
                                toRemove.add(ke);
                            }
                            ++k;
                        }
                        k = 0;
                        while (k < toRemove.size()) {
                            this.selectionElements.remove(toRemove.get(k));
                            ++k;
                        }
                        this.selectionElements.add(e);
                    }
                }
                return;
            }
            if (nde.sourceStart() > node.sourceStart() || node.sourceEnd() > nde.sourceEnd()) continue;
            if (element instanceof IParent) {
                if (nde instanceof TypeDeclaration) {
                    TypeDeclaration type = (TypeDeclaration)nde;
                    String typeName = this.getNodeChildName((ASTNode)type);
                    IModelElement e = this.findChildrenByName(typeName, element);
                    if (e == null && type.getName().startsWith("::")) {
                        try {
                            e = (IModelElement)this.findTypeFrom(this.sourceModule.getChildren(), "", type.getName().replaceAll("::", "\\$"), '$');
                        }
                        catch (ModelException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (e instanceof IParent) {
                        List stats = ((TypeDeclaration)nde).getStatements();
                        this.searchAddElementsTo(stats, node, (IParent)e);
                    }
                } else if (nde instanceof MethodDeclaration) {
                    IModelElement e;
                    MethodDeclaration method = (MethodDeclaration)nde;
                    String methodName = method.getName();
                    if (methodName.indexOf("::") != -1) {
                        String pName = methodName.substring(0, methodName.lastIndexOf("::"));
                        if ((pName = pName.replaceAll("::", "\\$")).equals("$")) {
                            element = this.sourceModule;
                        } else {
                            try {
                                element = this.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                                if (element == null) {
                                    return;
                                }
                            }
                            catch (ModelException e2) {
                                e2.printStackTrace();
                                return;
                            }
                        }
                        methodName = this.getNodeChildName(nde);
                    }
                    if ((e = this.findChildrenByName(methodName, element)) != null && e instanceof IParent) {
                        List stats = ((MethodDeclaration)nde).getStatements();
                        this.searchAddElementsTo(stats, node, (IParent)e);
                    }
                } else if (nde instanceof TclStatement) {
                    TclStatement s = (TclStatement)nde;
                    Expression commandId = s.getAt(0);
                    final IParent e = element;
                    if (commandId != null && commandId instanceof SimpleReference) {
                        String qname = ((SimpleReference)commandId).getName();
                        TclParseUtils.IProcessStatementAction action = new TclParseUtils.IProcessStatementAction(){

                            public void doAction(String name, Expression bl, int beforePosition) {
                                List code;
                                Expression block;
                                if (bl instanceof TclBlockExpression) {
                                    block = (TclBlockExpression)bl;
                                    code = block.parseBlock(block.sourceStart() + 1);
                                    TclSelectionEngine.this.searchAddElementsTo(code, node, e);
                                }
                                if (bl instanceof TclExecuteExpression) {
                                    block = (TclExecuteExpression)bl;
                                    code = block.parseExpression(block.sourceStart() + 1);
                                    TclSelectionEngine.this.searchAddElementsTo(code, node, e);
                                }
                            }
                        };
                        if (qname.equals("if")) {
                            TclParseUtils.processIf(s.getExpressions(), qname, 0, action);
                        } else if (qname.equals("while")) {
                            this.processWhile(qname, s, 0, action);
                        } else if (qname.equals("for")) {
                            this.processFor(qname, s, 0, action);
                        } else if (qname.equals("catch")) {
                            this.processCatch(qname, s, 0, action);
                        } else if (qname.equals("after")) {
                            this.processAfter(qname, s, 0, action);
                        }
                    }
                }
            }
            return;
        }
    }

    private String getNodeChildName(ASTNode node) {
        String[] var;
        if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            String name = method.getName();
            if (name.indexOf("::") != -1) {
                return name.substring(name.lastIndexOf("::") + 2);
            }
            return name;
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)node;
            String name = type.getName();
            return name;
        }
        if (node instanceof TclStatement && (var = TclParseUtils.returnVariable((TclStatement)node)) != null) {
            return var[0];
        }
        return null;
    }

    private IModelElement findChildrenByName(String typeName, IParent element) {
        try {
            IModelElement[] children;
            String nextName = null;
            int pos = typeName.indexOf("::");
            if (pos != -1) {
                nextName = typeName.substring(pos + 2);
                typeName = typeName.split("::")[0];
            }
            if ((children = element.getChildren()) != null) {
                int i = 0;
                while (i < children.length) {
                    String name = children[i].getElementName();
                    if (children[i] instanceof IField && name.indexOf(40) != -1) {
                        name = name.substring(0, name.indexOf(40));
                    }
                    if (name.equals(typeName)) {
                        if (nextName == null) {
                            return children[i];
                        }
                        if (children[i] instanceof IParent) {
                            return this.findChildrenByName(nextName, (IParent)children[i]);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean checkSelection(String source, int selectionSourceStart, int selectionSourceEnd) {
        boolean cheat = false;
        if (selectionSourceEnd < selectionSourceStart) {
            selectionSourceEnd = selectionSourceStart;
            cheat = true;
        }
        int start = TclParseUtils.startLineOrNoSymbol(selectionSourceStart, source);
        int end = TclParseUtils.endLineOrNoSymbol(selectionSourceEnd, source);
        if (end <= start) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        if (start > source.length() || end > source.length()) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        boolean isVariable = false;
        if (source.charAt(start) == '$') {
            isVariable = true;
        } else if (start > 0 && source.charAt(start - 1) == '{' && start - 1 > 0 && source.charAt(start - 2) == '$') {
            start -= 2;
            isVariable = true;
            while (end < source.length() && source.charAt(end) != '}') {
                ++end;
            }
            ++end;
        }
        if (isVariable && end < source.length() && source.charAt(end) == '(') {
            while (end < source.length() && source.charAt(end) != ')') {
                ++end;
            }
            ++end;
        }
        String sub = source.substring(start, end);
        if (!(isVariable || sub.indexOf(32) == -1 && sub.indexOf(9) == -1 && sub.indexOf(10) == -1)) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        this.actualSelectionStart = start;
        this.actualSelectionEnd = end;
        return true;
    }

    public IAssistParser getParser() {
        return this.parser;
    }
}

