/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclPreferencesMessages;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

class TclSmartTypingConfigurationBlock
extends AbstractConfigurationBlock {
    public TclSmartTypingConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> keys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeStrings"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBrackets"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBraces"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_tab"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "smartPasteMode"));
        return keys.toArray(new OverlayPreferenceStore.OverlayKey[keys.size()]);
    }

    public Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        Composite composite = this.createSubsection(control, null, TclPreferencesMessages.TCLSmartTypingConfigurationBlock_autoclose_title);
        this.addAutoclosingSection(composite);
        composite = this.createSubsection(control, null, TclPreferencesMessages.TCLSmartTypingConfigurationBlock_tabs_title);
        this.addTabSection(composite);
        composite = this.createSubsection(control, null, PreferencesMessages.SmartTypingConfigurationBlock_pasting_title);
        this.addPasteSection(composite);
        return control;
    }

    private void addPasteSection(Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        String label = null;
        label = TclPreferencesMessages.TCLSmartTypingConfigurationBlock_smartPaste_simple;
        this.addRadioButton(composite, label, "smartPasteMode", 1);
        label = TclPreferencesMessages.TCLSmartTypingConfigurationBlock_smartPaste_full;
        this.addRadioButton(composite, label, "smartPasteMode", 2);
    }

    private void addTabSection(Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        String label = TclPreferencesMessages.TCLSmartTypingConfigurationBlock_typing_smartTab;
        this.addCheckBox(composite, label, "smart_tab", 0);
        this.createMessage(composite);
    }

    private void addAutoclosingSection(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        String label = TclPreferencesMessages.TCLSmartTypingConfigurationBlock_closeStrings;
        this.addCheckBox(composite, label, "closeStrings", 0);
        label = TclPreferencesMessages.TCLSmartTypingConfigurationBlock_closeBrackets;
        this.addCheckBox(composite, label, "closeBrackets", 0);
        label = TclPreferencesMessages.TCLSmartTypingConfigurationBlock_closeBraces;
        this.addCheckBox(composite, label, "closeBraces", 0);
    }

    private void createMessage(final Composite composite) {
        String linkTooltip = PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tooltip;
        String indentMode = TclUI.getDefault().getPreferenceStore().getString("formatter.tabulation.char");
        String text = "tab".equals(indentMode) ? Messages.format((String)PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tab_text, (Object[])new String[]{Integer.toString(this.getTabDisplaySize())}) : Messages.format((String)PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_others_text, (Object[])new String[]{Integer.toString(this.getTabDisplaySize()), this.getIndentMode()});
        final Link link = new Link(composite, 0);
        link.setText(text);
        link.setToolTipText(linkTooltip);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 300;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.dltk.tcl.ui.EditorPreferences", null, null);
            }
        });
        OverlayPreferenceStore combinedStore = this.getPreferenceStore();
        IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){
            private boolean fHasRun = false;

            public void propertyChange(PropertyChangeEvent event) {
                if (this.fHasRun) {
                    return;
                }
                if (composite.isDisposed()) {
                    return;
                }
                String property = event.getProperty();
                if ("formatter.tabulation.char".equals(property) || "formatter.tabulation.size".equals(property)) {
                    this.fHasRun = true;
                    link.dispose();
                    TclSmartTypingConfigurationBlock.this.createMessage(composite);
                    Dialog.applyDialogFont((Control)composite);
                    composite.redraw();
                    composite.layout();
                }
            }
        };
        combinedStore.addPropertyChangeListener(propertyChangeListener);
        link.addDisposeListener(new DisposeListener((IPreferenceStore)combinedStore, propertyChangeListener){
            private final /* synthetic */ IPreferenceStore val$combinedStore;
            private final /* synthetic */ IPropertyChangeListener val$propertyChangeListener;
            {
                this.val$combinedStore = iPreferenceStore;
                this.val$propertyChangeListener = iPropertyChangeListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                this.val$combinedStore.removePropertyChangeListener(this.val$propertyChangeListener);
            }
        });
    }

    private String getIndentMode() {
        String indentMode = TclUI.getDefault().getPreferenceStore().getString("formatter.tabulation.char");
        if ("space".equals(indentMode)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_spaces;
        }
        if ("tab".equals(indentMode)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tabs;
        }
        if ("mixed".equals(indentMode)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tabsAndSpaces;
        }
        Assert.isTrue((boolean)false, (String)"Illegal indent mode - must not happen");
        return null;
    }

    private int getTabDisplaySize() {
        return TclUI.getDefault().getPreferenceStore().getInt("formatter.tabulation.size");
    }
}

