/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.internal.ui.text.hover.ScriptHoverMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;

public abstract class AbstractScriptEditorTextHover
implements IScriptEditorTextHover,
ITextHoverExtension {
    private static String fgStyleSheet;
    private IEditorPart fEditor;
    private IPreferenceStore fStore;
    private IBindingService fBindingService;
    static /* synthetic */ Class class$0;

    public AbstractScriptEditorTextHover() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.fStore = store;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            IWorkingCopyManager manager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(final ITextViewer textViewer, int offset) {
        final IRegion[] result = new IRegion[]{ScriptWordFinder.findWord(textViewer.getDocument(), offset)};
        textViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

            public void run() {
                Point selection = textViewer.getSelectedRange();
                int off = selection.x;
                int len = selection.y;
                if (len > 0) {
                    result[0] = new Region(off, len);
                }
            }
        });
        return result[0];
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IDLTKLanguageToolkit toolkit;
        String nature;
        block14: {
            IModelElement inputModelElement;
            block13: {
                nature = null;
                try {
                    inputModelElement = EditorUtility.getEditorInputModelElement(this.fEditor, false);
                    if (inputModelElement != null) break block13;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)inputModelElement);
            if (toolkit != null) break block14;
            return null;
        }
        nature = toolkit.getNatureId();
        if (nature == null) {
            return null;
        }
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            IModelElement[] result;
            block16: {
                String content;
                block15: {
                    try {
                        content = null;
                        try {
                            content = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                        }
                        catch (BadLocationException badLocationException) {}
                        result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (result != null) break block15;
                        return null;
                    }
                    catch (ModelException modelException) {
                        return null;
                    }
                }
                int nResults = result.length;
                if (nResults != 0) break block16;
                if (content != null) {
                    return this.getHoverInfo(nature, content);
                }
                return null;
            }
            return this.getHoverInfo(nature, result);
        }
        return null;
    }

    protected String getHoverInfo(String nature, IModelElement[] modelElements) {
        return null;
    }

    protected String getHoverInfo(String nature, String content) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractScriptEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (this.getPreferenceStore() == null) {
            return "{0}";
        }
        if (this.fBindingService == null || !this.getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        String keySequence = this.fBindingService.getBestActiveBindingFormattedFor("org.eclipse.dltk.ui.edit.text.script.show.documentation");
        if (keySequence == null) {
            return null;
        }
        return Messages.format(ScriptHoverMessages.ScriptTextHover_makeStickyHint, keySequence == null ? "" : keySequence);
    }

    protected static String getStyleSheet() {
        Bundle bundle;
        URL styleSheetURL;
        if (fgStyleSheet == null && (styleSheetURL = (bundle = Platform.getBundle((String)DLTKUIPlugin.getPluginId())).getEntry("/DocumentationHoverStyleSheet.css")) != null) {
            try {
                styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgStyleSheet = buffer.toString();
            }
            catch (IOException ex) {
                DLTKUIPlugin.log(ex);
                fgStyleSheet = "";
            }
        }
        return fgStyleSheet;
    }
}

