/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.rename.RenameResourceProcessor;
import org.eclipse.dltk.internal.corext.refactoring.rename.ScriptRenameRefactoring;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ScriptDeleteProcessor;
import org.eclipse.dltk.internal.corext.refactoring.structure.ScriptMoveRefactoring;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.dltk.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.dltk.internal.ui.refactoring.reorg.DeleteUserInterfaceManager;
import org.eclipse.dltk.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor;
import org.eclipse.dltk.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.swt.widgets.Shell;

public final class RefactoringExecutionStarter {
    public static void startDeleteRefactoring(Object[] elements, Shell shell) throws CoreException {
        DeleteRefactoring refactoring = new DeleteRefactoring((DeleteProcessor)new ScriptDeleteProcessor(elements));
        DeleteUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, shell, false);
    }

    public static void startCutRefactoring(Object[] elements, Shell shell) throws CoreException, InterruptedException, InvocationTargetException {
        ScriptDeleteProcessor processor = new ScriptDeleteProcessor(elements);
        processor.setQueries(new ReorgQueries(shell));
        new RefactoringExecutionHelper((Refactoring)new DeleteRefactoring((DeleteProcessor)processor), RefactoringCore.getConditionCheckingFailedSeverity(), false, shell, (IRunnableContext)new ProgressMonitorDialog(shell)).perform(false);
    }

    public static void startRenameRefactoring(IModelElement element, Shell shell) throws CoreException {
        RenameSupport support = RefactoringExecutionStarter.createRenameSupport(element, null, 1);
        if (support != null && support.preCheck().isOK()) {
            support.openDialog(shell);
        }
    }

    private static RenameSupport createRenameSupport(IModelElement element, String newName, int flags) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RenameSupport.create((IScriptProject)element, newName, flags);
            }
            case 3: {
                return RenameSupport.create((IProjectFragment)element, newName);
            }
            case 4: {
                return RenameSupport.create((IScriptFolder)element, newName, flags);
            }
            case 5: {
                return RenameSupport.create((ISourceModule)element, newName, flags);
            }
        }
        return null;
    }

    public static void startRenameResourceRefactoring(IResource resource, Shell shell) throws CoreException {
        ScriptRenameRefactoring refactoring = new ScriptRenameRefactoring(new RenameResourceProcessor(resource));
        RenameUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, shell, true);
    }

    public static void startRefactoring(IResource[] resources, IModelElement[] elements, Shell shell) throws ModelException {
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, elements);
        if (policy.canEnable()) {
            ScriptMoveProcessor processor = new ScriptMoveProcessor(policy);
            ScriptMoveRefactoring refactoring = new ScriptMoveRefactoring(processor);
            ReorgMoveWizard wizard = new ReorgMoveWizard(refactoring);
            processor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
            processor.setReorgQueries(new ReorgQueries((Wizard)wizard));
            new RefactoringStarter().activate((Refactoring)refactoring, wizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
        }
    }
}

