/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.core;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;

public class ScriptDebugManager {
    private static final String SCRIPT_DEBUG_MODEL_EXT_POINT = "org.eclipse.dltk.debug.scriptDebugModel";
    private static final String NATURE_ID = "natureId";
    private static final String DEBUG_MODEL_ID = "debugModelId";
    private static final String TYPE_FACTORY = "typeFactory";
    private static ScriptDebugManager instance;
    private final HashMap natureToInfoMap = new HashMap();
    private final HashMap modelToNatureMap = new HashMap();

    public static ScriptDebugManager getInstance() {
        if (instance == null) {
            instance = new ScriptDebugManager();
        }
        return instance;
    }

    private void loadExtenstionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] extensions = registry.getExtensionPoint(SCRIPT_DEBUG_MODEL_EXT_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length > 0) {
                IConfigurationElement element = elements[0];
                String natureId = element.getAttribute(NATURE_ID);
                String debugModelId = element.getAttribute(DEBUG_MODEL_ID);
                IScriptTypeFactory typeFactory = null;
                try {
                    typeFactory = (IScriptTypeFactory)element.createExecutableExtension(TYPE_FACTORY);
                }
                catch (CoreException coreException) {}
                if (natureId != null && debugModelId != null) {
                    this.natureToInfoMap.put(natureId, new Info(debugModelId, typeFactory));
                    this.modelToNatureMap.put(debugModelId, natureId);
                }
            }
            ++i;
        }
    }

    protected Info getInfo(String natureId) {
        return (Info)this.natureToInfoMap.get(natureId);
    }

    protected ScriptDebugManager() {
        this.loadExtenstionPoints();
    }

    public String getNatureByDebugModel(String debugModelId) {
        return (String)this.modelToNatureMap.get(debugModelId);
    }

    public String getDebugModelByNature(String natureId) {
        return this.getInfo((String)natureId).debugModelId;
    }

    public IScriptTypeFactory getTypeFactoryByNature(String natureId) {
        return this.getInfo((String)natureId).typeFactory;
    }

    public IScriptTypeFactory getTypeFactoryByDebugModel(String debugModelId) {
        return this.getTypeFactoryByNature(this.getNatureByDebugModel(debugModelId));
    }

    private static class Info {
        public final String debugModelId;
        public final IScriptTypeFactory typeFactory;

        public Info(String debugModelId, IScriptTypeFactory typeFactory) {
            this.debugModelId = debugModelId;
            this.typeFactory = typeFactory;
        }
    }
}

